/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.FileNotFoundException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.List;
import java.util.Map;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.WildFlyElytronClientDefaultSSLContextSpi;
import org.wildfly.security.auth.client._private.ElytronMessages;

public final class WildFlyElytronClientDefaultSSLContextProvider
extends Provider {
    private static final long serialVersionUID = -8281186085283177185L;
    public static final String ELYTRON_CLIENT_DEFAULT_SSL_CONTEXT_PROVIDER_NAME = "WildFlyElytronClientDefaultSSLContextProvider";
    public static final String SSL_CONTEXT_SERVICE_TYPE = "SSLContext";
    public static final String DEFAULT_ALGORITHM_NAME = "Default";
    public static final String SERVICE_IMPLEMENTATION_CLASS = "org.wildfly.security.auth.client.provider.WildFlyElytronClientDefaultSSLContextSpi";

    public WildFlyElytronClientDefaultSSLContextProvider() {
        this((String)null);
    }

    public WildFlyElytronClientDefaultSSLContextProvider(String configPath) {
        super(ELYTRON_CLIENT_DEFAULT_SSL_CONTEXT_PROVIDER_NAME, 1.0, "Elytron client provider for default SSLContext");
        this.putService(new ClientSSLContextProviderService(this, SSL_CONTEXT_SERVICE_TYPE, DEFAULT_ALGORITHM_NAME, SERVICE_IMPLEMENTATION_CLASS, null, null, configPath));
    }

    @Override
    public Provider configure(String configPath) {
        Provider.Service service = this.getService(SSL_CONTEXT_SERVICE_TYPE, DEFAULT_ALGORITHM_NAME);
        if (service instanceof ClientSSLContextProviderService) {
            ((ClientSSLContextProviderService)this.getService(SSL_CONTEXT_SERVICE_TYPE, DEFAULT_ALGORITHM_NAME)).setConfigPath(configPath);
        } else {
            this.putService(new ClientSSLContextProviderService(this, SSL_CONTEXT_SERVICE_TYPE, DEFAULT_ALGORITHM_NAME, SERVICE_IMPLEMENTATION_CLASS, null, null, configPath));
        }
        return this;
    }

    private static final class ClientSSLContextProviderService
    extends Provider.Service {
        String configPath;
        private final ThreadLocal<Integer> entered = new ThreadLocal();

        ClientSSLContextProviderService(Provider provider, String type, String algorithm, String className, List<String> aliases, Map<String, String> attributes, String configPath) {
            super(provider, type, algorithm, className, aliases, attributes);
            this.configPath = configPath;
        }

        public void setConfigPath(String configPath) {
            this.configPath = configPath;
        }

        @Override
        public Object newInstance(Object ignored) throws NoSuchAlgorithmException {
            WildFlyElytronClientDefaultSSLContextSpi sslContext;
            Integer enteredCountTmp = this.entered.get();
            this.entered.set(enteredCountTmp == null ? 1 : enteredCountTmp + 1);
            if (this.entered.get() >= 2) {
                throw ElytronMessages.log.sslContextForSecurityProviderCreatesInfiniteLoop();
            }
            try {
                sslContext = this.configPath == null ? new WildFlyElytronClientDefaultSSLContextSpi(AuthenticationContext.captureCurrent()) : new WildFlyElytronClientDefaultSSLContextSpi(this.configPath);
                if (this.entered.get() >= 2) {
                    throw ElytronMessages.log.sslContextForSecurityProviderCreatesInfiniteLoop();
                }
            }
            catch (GeneralSecurityException | ConfigXMLParseException e) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.trace("Unable to obtain SSLContext", e);
                }
                if (e.getCause() instanceof FileNotFoundException) {
                    throw ElytronMessages.log.clientConfigurationFileNotFound();
                }
                throw ElytronMessages.log.couldNotObtainClientDefaultSSLContext();
            }
            finally {
                this.entered.remove();
            }
            return sslContext;
        }
    }
}

