/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.MechanismDatabase;

final class NotCipherSuitePredicate
extends CipherSuitePredicate {
    private final CipherSuitePredicate predicate;

    NotCipherSuitePredicate(CipherSuitePredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    void toString(StringBuilder b) {
        b.append("not (");
        this.predicate.toString(b);
        b.append(")");
    }

    @Override
    boolean test(MechanismDatabase.Entry entry) {
        return !this.predicate.test(entry);
    }

    @Override
    boolean isAlwaysTrue() {
        return this.predicate.isAlwaysFalse();
    }

    @Override
    boolean isAlwaysFalse() {
        return this.predicate.isAlwaysTrue();
    }
}

