/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.ServerCredentialCallback;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class CredentialSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final Credential credential;

    public CredentialSaslServerFactory(SaslServerFactory delegate, Credential credential) {
        super(delegate);
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        this.credential = credential;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.delegate.createSaslServer(mechanism, protocol, serverName, props, callbacks -> {
            ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
            Iterator<Callback> iterator = list.iterator();
            while (iterator.hasNext()) {
                ServerCredentialCallback credentialCallback;
                Callback callback = iterator.next();
                if (!(callback instanceof ServerCredentialCallback) || !(credentialCallback = (ServerCredentialCallback)callback).isCredentialSupported(this.credential)) continue;
                credentialCallback.setCredential(this.credential);
                iterator.remove();
            }
            if (!list.isEmpty()) {
                cbh.handle(list.toArray(new Callback[list.size()]));
            }
        });
    }
}

