/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;

public abstract class IdentityCredentials
implements Iterable<Credential>,
CredentialSource {
    public static final IdentityCredentials NONE = new IdentityCredentials(){

        @Override
        IdentityCredentials getNext() {
            return null;
        }

        @Override
        public boolean contains(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            return false;
        }

        @Override
        public IdentityCredentials without(Predicate<? super Credential> predicate) {
            return this;
        }

        @Override
        Credential getCredential() {
            return null;
        }

        @Override
        public IdentityCredentials withoutMatching(Credential credential) {
            return this;
        }

        @Override
        public IdentityCredentials without(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            return this;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            return null;
        }

        @Override
        public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
            return null;
        }

        @Override
        public IdentityCredentials with(IdentityCredentials other) {
            return other;
        }

        @Override
        public Iterator<Credential> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public Spliterator<Credential> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    IdentityCredentials() {
    }

    public final boolean contains(Class<? extends Credential> credentialType) {
        return this.contains(credentialType, null);
    }

    @Override
    public final SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        return this.contains(credentialType, algorithmName, parameterSpec) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public final SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) {
        return this.contains(credentialType, algorithmName) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public final SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType) {
        return this.contains(credentialType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    public abstract boolean contains(Class<? extends Credential> var1, String var2, AlgorithmParameterSpec var3);

    public final boolean contains(Class<? extends Credential> credentialType, String algorithmName) {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.contains(credentialType, algorithmName, null);
    }

    public final boolean containsMatching(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        if (credential instanceof AlgorithmCredential) {
            AlgorithmCredential algorithmCredential = (AlgorithmCredential)credential;
            return this.contains(credential.getClass(), algorithmCredential.getAlgorithm(), algorithmCredential.getParameters());
        }
        return this.contains(credential.getClass(), null, null);
    }

    @Override
    public final <C extends Credential> C getCredential(Class<C> credentialType) {
        return this.getCredential(credentialType, null, null);
    }

    @Override
    public final <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
        return this.getCredential(credentialType, algorithmName, null);
    }

    @Override
    public abstract <C extends Credential> C getCredential(Class<C> var1, String var2, AlgorithmParameterSpec var3);

    @Override
    public final <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) {
        C credential = this.getCredential(credentialType);
        return credential == null ? null : (R)credential.castAndApply(credentialType, function);
    }

    @Override
    public final <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) {
        C credential = this.getCredential(credentialType, algorithmName);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, function);
    }

    @Override
    public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) {
        C credential = this.getCredential(credentialType, algorithmName, parameterSpec);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, parameterSpec, function);
    }

    public final IdentityCredentials withCredential(Credential credential) {
        return new CredentialNode(this.withoutMatching(credential), credential);
    }

    public abstract IdentityCredentials with(IdentityCredentials var1);

    public IdentityCredentials withoutMatching(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        return this.without(credential::matches);
    }

    @Override
    public final IdentityCredentials without(Class<? extends Credential> credentialType) {
        return this.without(credentialType::isInstance);
    }

    @Override
    public final IdentityCredentials without(Class<? extends Credential> credentialType, String algorithmName) {
        return this.without((Class)credentialType, algorithmName, (AlgorithmParameterSpec)null);
    }

    @Override
    public IdentityCredentials without(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        if (algorithmName == null) {
            if (parameterSpec == null) {
                return this.without((Class)credentialType);
            }
            return this.without(credentialType::isInstance);
        }
        if (AlgorithmCredential.class.isAssignableFrom(credentialType)) {
            Class<AlgorithmCredential> algorithmCredentialType = credentialType.asSubclass(AlgorithmCredential.class);
            if (parameterSpec == null) {
                return this.without(AlgorithmCredential.class, (? super C cred) -> algorithmCredentialType.isInstance(cred) && algorithmName.equals(cred.getAlgorithm()));
            }
            return this.without(AlgorithmCredential.class, (? super C cred) -> algorithmCredentialType.isInstance(cred) && algorithmName.equals(cred.getAlgorithm()) && cred.impliesParameters(parameterSpec));
        }
        return this;
    }

    public abstract IdentityCredentials without(Predicate<? super Credential> var1);

    public final <C extends Credential> IdentityCredentials without(Class<C> credentialType, Predicate<? super C> predicate) {
        return this.without((? super Credential c) -> credentialType.isInstance(c) && predicate.test((Object)credentialType.cast(c)));
    }

    @Override
    public Iterator<Credential> iterator() {
        return new Itr(this);
    }

    @Override
    public Spliterator<Credential> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1297);
    }

    public abstract int size();

    abstract IdentityCredentials getNext();

    abstract Credential getCredential();

    static class CredentialNode
    extends IdentityCredentials {
        private final IdentityCredentials next;
        private final Credential credential;
        private final int size;

        CredentialNode(IdentityCredentials next, Credential credential) {
            this.next = next;
            this.credential = credential;
            this.size = next.size() + 1;
        }

        private CredentialNode withNext(IdentityCredentials next) {
            if (next == this.next) {
                return this;
            }
            return new CredentialNode(next, this.credential);
        }

        @Override
        IdentityCredentials getNext() {
            return this.next;
        }

        @Override
        Credential getCredential() {
            return this.credential;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            Credential credential = this.credential;
            if (credential instanceof AlgorithmCredential) {
                AlgorithmCredential algorithmCredential = (AlgorithmCredential)credential;
                if (parameterSpec != null && !algorithmCredential.impliesParameters(parameterSpec)) {
                    return this.next.getCredential(credentialType, algorithmName);
                }
                if (credentialType.isInstance(algorithmCredential) && (algorithmName == null || algorithmName.equals(algorithmCredential.getAlgorithm()))) {
                    return (C)((Credential)credentialType.cast(algorithmCredential));
                }
                return this.next.getCredential(credentialType, algorithmName);
            }
            if (algorithmName == null && credentialType.isInstance(credential)) {
                return (C)((Credential)credentialType.cast(credential));
            }
            return this.next.getCredential(credentialType, algorithmName);
        }

        @Override
        public boolean contains(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            Credential credential = this.credential;
            if (credential instanceof AlgorithmCredential) {
                AlgorithmCredential algorithmCredential = (AlgorithmCredential)credential;
                return !(!credentialType.isInstance(credential) || algorithmName != null && !algorithmName.equals(algorithmCredential.getAlgorithm()) || parameterSpec != null && !algorithmCredential.impliesParameters(parameterSpec));
            }
            return algorithmName == null && parameterSpec == null && credentialType.isInstance(credential);
        }

        @Override
        public IdentityCredentials without(Predicate<? super Credential> predicate) {
            Assert.checkNotNullParam((String)"predicate", predicate);
            if (predicate.test(this.credential)) {
                return this.next.without(predicate);
            }
            return this.withNext(this.next.without(predicate));
        }

        @Override
        public IdentityCredentials with(IdentityCredentials other) {
            if (other == NONE) {
                return this;
            }
            return this.withNext(this.without((? super Credential cred) -> cred instanceof AlgorithmCredential ? other.getCredential(cred.getClass(), ((AlgorithmCredential)cred).getAlgorithm()) != null : other.getCredential(cred.getClass()) != null));
        }
    }

    static class Itr
    implements Iterator<Credential> {
        private IdentityCredentials current;

        Itr(IdentityCredentials current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != NONE;
        }

        @Override
        public Credential next() {
            IdentityCredentials current = this.current;
            if (current == NONE) {
                throw new NoSuchElementException();
            }
            try {
                Credential credential = current.getCredential();
                return credential;
            }
            finally {
                this.current = current.getNext();
            }
        }
    }
}

