/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionObjIntConsumer;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.Scoped;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

public final class FlexibleIdentityAssociation
implements Scoped,
Supplier<SecurityIdentity> {
    private final SecurityDomain securityDomain;
    private volatile SecurityIdentity securityIdentity;

    FlexibleIdentityAssociation(SecurityDomain securityDomain, SecurityIdentity securityIdentity) {
        assert (securityIdentity != null && securityDomain == securityIdentity.getSecurityDomain());
        this.securityDomain = securityDomain;
        this.securityIdentity = securityIdentity;
    }

    public void setIdentity(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam("securityIdentity", securityIdentity);
        if (securityIdentity.getSecurityDomain() != this.securityDomain) {
            throw ElytronMessages.log.securityDomainMismatch();
        }
        this.securityIdentity = securityIdentity;
    }

    @Override
    public SecurityIdentity get() {
        return this.securityIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, U, R> R runAsFunction(BiFunction<T, U, R> action, T parameter1, U parameter2) {
        Supplier<SecurityIdentity> old = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            R r = action.apply(parameter1, parameter2);
            return r;
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, U> void runAsConsumer(BiConsumer<T, U> action, T parameter1, U parameter2) {
        Supplier<SecurityIdentity> old = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.accept(parameter1, parameter2);
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void runAsObjIntConsumer(ObjIntConsumer<T> action, T parameter1, int parameter2) {
        Supplier<SecurityIdentity> old = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.accept(parameter1, parameter2);
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, U, R, E extends Exception> R runAsFunctionEx(ExceptionBiFunction<T, U, R, E> action, T parameter1, U parameter2) throws E {
        Supplier<SecurityIdentity> old = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            R r = action.apply(parameter1, parameter2);
            return r;
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, U, E extends Exception> void runAsConsumerEx(ExceptionBiConsumer<T, U, E> action, T parameter1, U parameter2) throws E {
        Supplier<SecurityIdentity> old = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.accept(parameter1, parameter2);
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> void runAsObjIntConsumerEx(ExceptionObjIntConsumer<T, E> action, T parameter1, int parameter2) throws E {
        Supplier<SecurityIdentity> old = this.securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.accept(parameter1, parameter2);
        }
        finally {
            this.securityDomain.setCurrentSecurityIdentity(old);
        }
    }
}

