/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;

public class SaslFactoriesApiTest {
    private static final String REGEX_MECHANISM_NAME = "^[A-Z0-9-_]{1,20}$";

    @Test
    public void testSaslClientFactoryGetMechanismNamesNotNull() {
        Collections.list(Sasl.getSaslClientFactories()).forEach(cf -> {
            Assert.assertNotNull((Object)cf.getMechanismNames(null));
            Assert.assertNotNull((Object)cf.getMechanismNames(Collections.emptyMap()));
        });
    }

    @Test
    public void testSaslClientFactoryGetMechanismNamesValid() {
        Collections.list(Sasl.getSaslClientFactories()).stream().flatMap(cf -> Arrays.stream(cf.getMechanismNames(Collections.emptyMap()))).forEach(s -> MatcherAssert.assertThat((Object)s, RegularExpressionMatcher.matchesPattern(REGEX_MECHANISM_NAME)));
    }

    @Test
    public void testCreateSaslClientNullParams() {
        Collections.list(Sasl.getSaslClientFactories()).forEach(cf -> Arrays.stream(cf.getMechanismNames(Collections.emptyMap())).forEach(mech -> {
            try {
                SaslClient sc = cf.createSaslClient(new String[]{mech}, null, "test", "localhost", null, null);
                if (sc != null) {
                    sc.dispose();
                }
            }
            catch (IllegalArgumentException | SaslException exception) {
                // empty catch block
            }
        }));
    }

    @Test
    public void testSaslServerFactoryGetMechanismNamesNotNull() {
        Collections.list(Sasl.getSaslServerFactories()).forEach(sf -> {
            Assert.assertNotNull((Object)sf.getMechanismNames(null));
            Assert.assertNotNull((Object)sf.getMechanismNames(Collections.emptyMap()));
        });
    }

    @Test
    public void testSaslServerFactoryGetMechanismNamesValid() {
        Collections.list(Sasl.getSaslServerFactories()).stream().flatMap(sf -> Arrays.stream(sf.getMechanismNames(Collections.emptyMap()))).forEach(s -> MatcherAssert.assertThat((Object)s, RegularExpressionMatcher.matchesPattern(REGEX_MECHANISM_NAME)));
    }

    @Test
    public void testCreateSaslServerNullParams() {
        Collections.list(Sasl.getSaslServerFactories()).forEach(sf -> Arrays.stream(sf.getMechanismNames(Collections.emptyMap())).forEach(mech -> {
            try {
                SaslServer ss = sf.createSaslServer((String)mech, "test", null, null, null);
                if (ss != null) {
                    ss.dispose();
                }
            }
            catch (IllegalArgumentException | SaslException exception) {
                // empty catch block
            }
        }));
    }

    private static class RegularExpressionMatcher
    extends TypeSafeMatcher<String> {
        private final Pattern pattern;

        public RegularExpressionMatcher(String regExp) {
            this.pattern = Pattern.compile(Objects.requireNonNull(regExp));
        }

        public void describeTo(Description description) {
            description.appendText("matches regular expression ").appendValue((Object)this.pattern);
        }

        public boolean matchesSafely(String item) {
            return this.pattern.matcher(item).matches();
        }

        @Factory
        public static Matcher<String> matchesPattern(String pattern) {
            return new RegularExpressionMatcher(pattern);
        }
    }
}

