/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.test;

import java.net.URI;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ClientUtils;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.sasl.anonymous.AnonymousClientFactory;
import org.wildfly.security.sasl.anonymous.AnonymousSaslClient;
import org.wildfly.security.sasl.anonymous.AnonymousSaslServer;
import org.wildfly.security.sasl.anonymous.AnonymousServerFactory;
import org.wildfly.security.sasl.anonymous.WildFlyElytronSaslAnonymousProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;
import org.wildfly.security.sasl.test.SaslTestUtil;

public class AnonymousTest {
    private static final String ANONYMOUS = "ANONYMOUS";
    private static final Provider provider = WildFlyElytronSaslAnonymousProvider.getInstance();

    @BeforeClass
    public static void registerPasswordProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removePasswordProvider() {
        Security.removeProvider(provider.getName());
    }

    @Test
    public void testPolicyIndirect_Server() throws Exception {
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        SaslServer server = Sasl.createSaslServer(ANONYMOUS, "TestProtocol", "TestServer", props, null);
        Assert.assertEquals(AnonymousSaslServer.class, server.getClass());
        props.put("javax.security.sasl.policy.noanonymous", true);
        server = Sasl.createSaslServer(ANONYMOUS, "TestProtocol", "TestServer", props, null);
        Assert.assertNull((Object)server);
    }

    @Test
    public void testPolicyIndirect_Client() throws Exception {
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        SaslClient client = Sasl.createSaslClient(new String[]{ANONYMOUS}, "TestUser", "TestProtocol", "TestServer", props, null);
        Assert.assertEquals(AnonymousSaslClient.class, client.getClass());
        props.put("javax.security.sasl.policy.noanonymous", true);
        client = Sasl.createSaslClient(new String[]{ANONYMOUS}, "TestUser", "TestProtocol", "TestServer", props, null);
        Assert.assertNull((Object)client);
    }

    @Test
    public void testPolicyDirect_Server() {
        SaslServerFactory factory = SaslTestUtil.obtainSaslServerFactory(AnonymousServerFactory.class);
        Assert.assertNotNull((String)"SaslServerFactory not registered", (Object)factory);
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        String[] mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertSingleMechanism((String)ANONYMOUS, (String[])mechanisms);
        props.put("javax.security.sasl.policy.noanonymous", true);
        mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertNoMechanisms((String[])mechanisms);
    }

    @Test
    public void testPolicyDirect_Client() {
        SaslClientFactory factory = SaslTestUtil.obtainSaslClientFactory(AnonymousClientFactory.class);
        Assert.assertNotNull((String)"SaslClientFactory not registered", (Object)factory);
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        String[] mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertSingleMechanism((String)ANONYMOUS, (String[])mechanisms);
        props.put("javax.security.sasl.policy.noanonymous", true);
        mechanisms = factory.getMechanismNames(props);
        SaslTestUtil.assertNoMechanisms((String[])mechanisms);
    }

    @Test
    public void testSuccessfulExchange() throws Exception {
        SaslServer server = this.createSaslServer();
        CallbackHandler clientCallback = this.createClientCallbackHandler();
        SaslClient client = Sasl.createSaslClient(new String[]{ANONYMOUS}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        server.evaluateResponse(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"anonymous", (Object)server.getAuthorizationID());
    }

    private SaslServer createSaslServer() throws Exception {
        return new SaslServerBuilder(AnonymousServerFactory.class, ANONYMOUS).build();
    }

    private CallbackHandler createClientCallbackHandler() throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useAnonymous());
        return ClientUtils.getCallbackHandler(new URI("doesnot://matter?"), context);
    }
}

