/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ldap;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Provider;
import java.security.spec.KeySpec;
import java.util.Collections;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.ldap.LdapTestSuite;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.Encoding;
import org.wildfly.security.password.spec.OneTimePasswordSpec;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class PasswordSupportSuiteChild {
    private static SecurityRealm simpleToDnRealm;
    private static SecurityRealm charsetDnRealm;
    private static SecurityRealm encodingDnRealm;

    @BeforeClass
    public static void createRealm() {
        simpleToDnRealm = LdapSecurityRealmBuilder.builder().setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setSearchDn("dc=elytron,dc=wildfly,dc=org").setRdnIdentifier("uid").build().userPasswordCredentialLoader().enablePersistence().build().otpCredentialLoader().setOtpAlgorithmAttribute("otpAlgorithm").setOtpHashAttribute("otpHash").setOtpSeedAttribute("otpSeed").setOtpSequenceAttribute("otpSequence").build().build();
        charsetDnRealm = LdapSecurityRealmBuilder.builder().setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).setHashCharset(Charset.forName("gb2312")).identityMapping().setSearchDn("dc=elytron,dc=wildfly,dc=org").setRdnIdentifier("uid").build().userPasswordCredentialLoader().enablePersistence().build().otpCredentialLoader().setOtpAlgorithmAttribute("otpAlgorithm").setOtpHashAttribute("otpHash").setOtpSeedAttribute("otpSeed").setOtpSequenceAttribute("otpSequence").build().build();
        encodingDnRealm = LdapSecurityRealmBuilder.builder().setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).setHashEncoding(Encoding.HEX).setHashCharset(Charset.forName("gb2312")).identityMapping().setSearchDn("dc=elytron,dc=wildfly,dc=org").setRdnIdentifier("uid").build().userPasswordCredentialLoader().enablePersistence().build().otpCredentialLoader().setOtpAlgorithmAttribute("otpAlgorithm").setOtpHashAttribute("otpHash").setOtpSeedAttribute("otpSeed").setOtpSequenceAttribute("otpSequence").build().build();
    }

    @Test
    public void testPlainUser() throws Exception {
        this.performSimpleNameTest("plainUser", "clear", "plainPassword".toCharArray());
    }

    @Test
    public void testMd5User() throws Exception {
        this.performSimpleNameTest("md5User", "simple-digest-md5", "md5Password".toCharArray());
    }

    @Test
    public void testMd5UserWithCharset() throws Exception {
        this.performSimpleNameTest("md5UserCharset", "simple-digest-md5", "password\u5bc6\u7801".toCharArray(), Charset.forName("gb2312"), charsetDnRealm);
    }

    @Test
    public void testMd5UserWithCharsetAndHexEncoding() throws Exception {
        this.performSimpleNameTest("md5UserCharsetHex", "simple-digest-md5", "password\u5bc6\u7801".toCharArray(), Charset.forName("gb2312"), encodingDnRealm);
    }

    @Test
    public void testSmd5User() throws Exception {
        this.performSimpleNameTest("smd5User", "password-salt-digest-md5", "smd5Password".toCharArray());
    }

    @Test
    public void testSmd5UserWithCharset() throws Exception {
        this.performSimpleNameTest("smd5UserCharset", "password-salt-digest-md5", "password\u5bc6\u7801".toCharArray(), Charset.forName("gb2312"), charsetDnRealm);
    }

    @Test
    public void testSmd5UserWithCharsetAndHexEncoded() throws Exception {
        this.performSimpleNameTest("smd5UserCharsetHex", "password-salt-digest-md5", "password\u5bc6\u7801".toCharArray(), Charset.forName("gb2312"), encodingDnRealm);
    }

    @Test
    public void testSha512User() throws Exception {
        this.performSimpleNameTest("sha512User", "simple-digest-sha-512", "sha512Password".toCharArray());
    }

    @Test
    public void testSha512UserWithCharset() throws Exception {
        this.performSimpleNameTest("sha512UserCharset", "simple-digest-sha-512", "password\u5bc6\u7801".toCharArray(), Charset.forName("gb2312"), charsetDnRealm);
    }

    @Test
    public void testSha512UserWithCharsetAndHexEncoded() throws Exception {
        this.performSimpleNameTest("sha512UserCharsetHex", "simple-digest-sha-512", "password\u5bc6\u7801".toCharArray(), Charset.forName("gb2312"), encodingDnRealm);
    }

    @Test
    public void testSsha512User() throws Exception {
        this.performSimpleNameTest("ssha512User", "password-salt-digest-sha-512", "ssha512Password".toCharArray());
    }

    @Test
    public void testSsha512UserWithCharset() throws Exception {
        this.performSimpleNameTest("ssha512UserCharset", "password-salt-digest-sha-512", "password\u5bc6\u7801".toCharArray(), Charset.forName("gb2312"), charsetDnRealm);
    }

    @Test
    public void testSsha512UserWithCharsetAndHexEncoded() throws Exception {
        this.performSimpleNameTest("ssha512UserCharsetHex", "password-salt-digest-sha-512", "password\u5bc6\u7801".toCharArray(), Charset.forName("gb2312"), encodingDnRealm);
    }

    @Test
    public void testCryptUser() throws Exception {
        this.performSimpleNameTest("cryptUser", "crypt-des", "cryptIt".toCharArray());
    }

    @Test
    public void testCryptUserWithCharset() throws Exception {
        this.performSimpleNameTest("cryptUserCharset", "crypt-des", "password\u5bc6\u7801".toCharArray(), Charset.forName("gb2312"), charsetDnRealm);
    }

    @Test
    public void testCryptUserLongPassword() throws Exception {
        this.performSimpleNameTest("cryptUserLong", "crypt-des", "cryptPassword".toCharArray());
    }

    @Test
    public void testBsdCryptUser() throws Exception {
        this.performSimpleNameTest("bsdCryptUser", "bsd-crypt-des", "cryptPassword".toCharArray());
    }

    @Test
    public void testBsdCryptUserWithCharset() throws Exception {
        this.performSimpleNameTest("bsdCryptUserCharset", "bsd-crypt-des", "password\u5bc6\u7801".toCharArray(), Charset.forName("gb2312"), charsetDnRealm);
    }

    @Test
    public void testBsdCryptUserBinary() throws Exception {
        this.performSimpleNameTest("bsdCryptUser_binary", "bsd-crypt-des", "cryptPassword".toCharArray());
    }

    @Test
    public void testOneTimePasswordUser0() throws Exception {
        SupportLevel support = simpleToDnRealm.getCredentialAcquireSupport(PasswordCredential.class, null, null);
        Assert.assertEquals((String)"Pre identity", (Object)SupportLevel.SUPPORTED, (Object)support);
        RealmIdentity identity = simpleToDnRealm.getRealmIdentity((Principal)new NamePrincipal("userWithOtp"));
        this.verifyPasswordSupport(identity, "otp-sha1", SupportLevel.SUPPORTED);
        OneTimePassword otp = (OneTimePassword)((PasswordCredential)identity.getCredential(PasswordCredential.class, "otp-sha1")).getPassword(OneTimePassword.class);
        Assert.assertNotNull((Object)otp);
        Assert.assertEquals((long)1234L, (long)otp.getSequenceNumber());
        Assert.assertArrayEquals((byte[])new byte[]{97, 98, 99, 100}, (byte[])otp.getHash());
        Assert.assertEquals((Object)"efgh", (Object)otp.getSeed());
    }

    @Test
    public void testOneTimePasswordUser1Update() throws Exception {
        OneTimePasswordSpec spec = new OneTimePasswordSpec(new byte[]{105, 106, 107}, "lmn", 4321);
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"otp-sha1", (Provider)WildFlyElytronPasswordProvider.getInstance());
        OneTimePassword password = (OneTimePassword)passwordFactory.generatePassword((KeySpec)spec);
        Assert.assertNotNull((Object)password);
        ModifiableRealmIdentity identity = (ModifiableRealmIdentity)simpleToDnRealm.getRealmIdentity((Principal)new NamePrincipal("userWithOtp"));
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((Object)SupportLevel.POSSIBLY_SUPPORTED, (Object)simpleToDnRealm.getCredentialAcquireSupport(PasswordCredential.class, "otp-sha1", null));
        Assert.assertEquals((Object)SupportLevel.SUPPORTED, (Object)identity.getCredentialAcquireSupport(PasswordCredential.class, "otp-sha1", null));
        identity.setCredentials(Collections.singleton(new PasswordCredential((Password)password)));
        ModifiableRealmIdentity newIdentity = (ModifiableRealmIdentity)simpleToDnRealm.getRealmIdentity((Principal)new NamePrincipal("userWithOtp"));
        Assert.assertNotNull((Object)newIdentity);
        this.verifyPasswordSupport((RealmIdentity)newIdentity, "otp-sha1", SupportLevel.SUPPORTED);
        OneTimePassword otp = (OneTimePassword)((PasswordCredential)newIdentity.getCredential(PasswordCredential.class, "otp-sha1")).getPassword(OneTimePassword.class);
        Assert.assertNotNull((Object)otp);
        Assert.assertEquals((long)4321L, (long)otp.getSequenceNumber());
        Assert.assertArrayEquals((byte[])new byte[]{105, 106, 107}, (byte[])otp.getHash());
        Assert.assertEquals((Object)"lmn", (Object)otp.getSeed());
    }

    @Test
    public void testOneTimePasswordUser2SetCredentials() throws Exception {
        OneTimePasswordSpec spec = new OneTimePasswordSpec(new byte[]{111, 112, 113}, "rst", 65);
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"otp-sha1", (Provider)WildFlyElytronPasswordProvider.getInstance());
        OneTimePassword password = (OneTimePassword)passwordFactory.generatePassword((KeySpec)spec);
        Assert.assertNotNull((Object)password);
        ModifiableRealmIdentity identity = (ModifiableRealmIdentity)simpleToDnRealm.getRealmIdentity((Principal)new NamePrincipal("userWithOtp"));
        Assert.assertNotNull((Object)identity);
        identity.setCredentials(Collections.emptyList());
        identity.setCredentials(Collections.emptyList());
        identity.setCredentials(Collections.singleton(new PasswordCredential((Password)password)));
        ModifiableRealmIdentity newIdentity = (ModifiableRealmIdentity)simpleToDnRealm.getRealmIdentity((Principal)new NamePrincipal("userWithOtp"));
        Assert.assertNotNull((Object)newIdentity);
        this.verifyPasswordSupport((RealmIdentity)newIdentity, "otp-sha1", SupportLevel.SUPPORTED);
        OneTimePassword otp = (OneTimePassword)((PasswordCredential)newIdentity.getCredential(PasswordCredential.class, "otp-sha1")).getPassword(OneTimePassword.class);
        Assert.assertNotNull((Object)otp);
        Assert.assertEquals((long)65L, (long)otp.getSequenceNumber());
        Assert.assertArrayEquals((byte[])new byte[]{111, 112, 113}, (byte[])otp.getHash());
        Assert.assertEquals((Object)"rst", (Object)otp.getSeed());
    }

    @Test
    public void testUserPasswordUserUpdate() throws Exception {
        PasswordFactory factory = PasswordFactory.getInstance((String)"clear", (Provider)WildFlyElytronPasswordProvider.getInstance());
        ClearPassword password = (ClearPassword)factory.generatePassword((KeySpec)new ClearPasswordSpec("createdPassword".toCharArray()));
        Assert.assertNotNull((Object)password);
        ModifiableRealmIdentity identity = (ModifiableRealmIdentity)simpleToDnRealm.getRealmIdentity((Principal)new NamePrincipal("userToChange"));
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((Object)SupportLevel.POSSIBLY_SUPPORTED, (Object)simpleToDnRealm.getCredentialAcquireSupport(PasswordCredential.class, "clear", null));
        Assert.assertEquals((Object)SupportLevel.SUPPORTED, (Object)identity.getCredentialAcquireSupport(PasswordCredential.class, "clear", null));
        identity.setCredentials(Collections.singleton(new PasswordCredential((Password)password)));
        ModifiableRealmIdentity newIdentity = (ModifiableRealmIdentity)simpleToDnRealm.getRealmIdentity((Principal)new NamePrincipal("userToChange"));
        Assert.assertNotNull((Object)newIdentity);
        this.verifyPasswordSupport((RealmIdentity)newIdentity, "clear", SupportLevel.SUPPORTED);
        ClearPassword password2 = (ClearPassword)((PasswordCredential)newIdentity.getCredential(PasswordCredential.class, "clear")).getPassword(ClearPassword.class);
        Assert.assertNotNull((Object)password2);
        Assert.assertEquals((Object)"createdPassword", (Object)new String(password2.getPassword()));
    }

    private void performSimpleNameTest(String simpleName, String algorithm, char[] password) throws NoSuchAlgorithmException, InvalidKeyException, RealmUnavailableException {
        this.performSimpleNameTest(simpleName, algorithm, password, StandardCharsets.UTF_8, simpleToDnRealm);
    }

    private void performSimpleNameTest(String simpleName, String algorithm, char[] password, Charset hashCharset, SecurityRealm realm) throws NoSuchAlgorithmException, InvalidKeyException, RealmUnavailableException {
        RealmIdentity realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal(simpleName));
        SupportLevel support = realm.getCredentialAcquireSupport(PasswordCredential.class, algorithm, null);
        Assert.assertEquals((String)"Pre identity", (Object)SupportLevel.POSSIBLY_SUPPORTED, (Object)support);
        this.verifyPasswordSupport(realmIdentity, algorithm, SupportLevel.SUPPORTED);
        this.verifyPassword(realmIdentity, algorithm, password, hashCharset);
    }

    private void verifyPasswordSupport(RealmIdentity identity, String algorithm, SupportLevel requiredSupport) throws RealmUnavailableException {
        SupportLevel credentialSupport = identity.getCredentialAcquireSupport(PasswordCredential.class, algorithm, null);
        Assert.assertEquals((String)"Identity level support", (Object)requiredSupport, (Object)credentialSupport);
    }

    private void verifyPassword(RealmIdentity identity, String algorithm, char[] password, Charset hashCharset) throws NoSuchAlgorithmException, InvalidKeyException, RealmUnavailableException {
        Password loadedPassword = ((PasswordCredential)identity.getCredential(PasswordCredential.class)).getPassword();
        PasswordFactory factory = PasswordFactory.getInstance((String)algorithm, (Provider)WildFlyElytronPasswordProvider.getInstance());
        Password translated = factory.translate(loadedPassword);
        Assert.assertTrue((String)"Valid Password", (boolean)factory.verify(translated, password, hashCharset));
        Assert.assertFalse((String)"Invalid Password", (boolean)factory.verify(translated, "LetMeIn".toCharArray()));
        Assert.assertTrue((boolean)identity.verifyEvidence((Evidence)new PasswordGuessEvidence(password)));
    }
}

