/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.password.impl.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String emptyParameter = "ELY00002: Parameter %s is empty";
    private static final String unrecognizedAlgorithm = "ELY00004: Unrecognized algorithm \"%s\"";
    private static final String mechInvalidOTPAlgorithm = "ELY05151: Invalid OTP algorithm \"%s\"";
    private static final String invalidKeySpecNoSuchMessageDigestAlgorithm = "ELY08013: No such MessageDigest algorithm for \"%s\"";
    private static final String invalidKeyNoSuchMessageDigestAlgorithm = "ELY08014: No such MessageDigest algorithm for \"%s\"";
    private static final String invalidKeyCannotVerifyPassword = "ELY08015: Cannot verify password";
    private static final String invalidKeyDesCryptPasswordHashMustBeBytes = "ELY08017: DES crypt password hash must be %d bytes";
    private static final String invalidParameterSpecSaltMustBeBytesBits = "ELY08018: Salt must be %d bytes (%d bits)";
    private static final String invalidNumberOfRoundsMustBeIntBetween = "ELY08020: Invalid number of rounds. Must be an integer between %d and %d, inclusive";
    private static final String invalidSaltMustBeBytesLong = "ELY08021: Invalid salt: must be %d bytes long";
    private static final String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes = "ELY08022: BSD DES crypt password hash must be %d bytes";
    private static final String invalidParameterSpecSaltMustBeBytes = "ELY08023: Salt must be %d bytes";
    private static final String invalidKeyBsdDesCryptPasswordHashMustBeBytes = "ELY08024: BSD DES crypt password hash must be %d bytes";
    private static final String invalidKeySpecExpectedSpecGotSpec = "ELY08025: Expected to get a \"%s\" as spec, got \"%s\"";
    private static final String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec = "ELY08026: Unknown algorithm or incompatible PasswordSpec";
    private static final String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm = "ELY08027: Unknown password type or algorithm";
    private static final String noSuchAlgorithmInvalidAlgorithm = "ELY08028: Invalid algorithm \"%s\"";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String emptyParameter$str() {
        return emptyParameter;
    }

    @Override
    public final IllegalArgumentException emptyParameter(String parameter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.emptyParameter$str(), parameter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unrecognizedAlgorithm$str() {
        return unrecognizedAlgorithm;
    }

    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unrecognizedAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTPAlgorithm$str() {
        return mechInvalidOTPAlgorithm;
    }

    @Override
    public final SaslException mechInvalidOTPAlgorithm(String algorithm) {
        SaslException result = new SaslException(String.format(this.getLoggingLocale(), this.mechInvalidOTPAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecNoSuchMessageDigestAlgorithm$str() {
        return invalidKeySpecNoSuchMessageDigestAlgorithm;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(String algorithm) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoSuchMessageDigestAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyNoSuchMessageDigestAlgorithm$str() {
        return invalidKeyNoSuchMessageDigestAlgorithm;
    }

    @Override
    public final InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(String algorithm) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyNoSuchMessageDigestAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyCannotVerifyPassword$str() {
        return invalidKeyCannotVerifyPassword;
    }

    @Override
    public final InvalidKeyException invalidKeyCannotVerifyPassword(Throwable cause) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyCannotVerifyPassword$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyDesCryptPasswordHashMustBeBytes;
    }

    @Override
    public final InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyDesCryptPasswordHashMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidParameterSpecSaltMustBeBytesBits$str() {
        return invalidParameterSpecSaltMustBeBytesBits;
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(int bytes, int bits) {
        InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpecSaltMustBeBytesBits$str(), bytes, bits));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNumberOfRoundsMustBeIntBetween$str() {
        return invalidNumberOfRoundsMustBeIntBetween;
    }

    @Override
    public final IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(int min, int max) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNumberOfRoundsMustBeIntBetween$str(), min, max));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSaltMustBeBytesLong$str() {
        return invalidSaltMustBeBytesLong;
    }

    @Override
    public final IllegalArgumentException invalidSaltMustBeBytesLong(int length) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSaltMustBeBytesLong$str(), length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeySpecBsdDesCryptPasswordHashMustBeBytes;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidParameterSpecSaltMustBeBytes$str() {
        return invalidParameterSpecSaltMustBeBytes;
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(int bytes) {
        InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpecSaltMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyBsdDesCryptPasswordHashMustBeBytes;
    }

    @Override
    public final InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecExpectedSpecGotSpec$str() {
        return invalidKeySpecExpectedSpecGotSpec;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(String expected, String got) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecExpectedSpecGotSpec$str(), expected, got));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str() {
        return invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return invalidKeyUnknownUnknownPasswordTypeOrAlgorithm;
    }

    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchAlgorithmInvalidAlgorithm$str() {
        return noSuchAlgorithmInvalidAlgorithm;
    }

    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(String algorithm) {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noSuchAlgorithmInvalidAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

