/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.impl.PasswordUtil;
import org.wildfly.security.password.interfaces.MaskedPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.MaskedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.MaskedPasswordSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

final class MaskedPasswordImpl
extends AbstractPasswordImpl
implements MaskedPassword {
    private static final long serialVersionUID = -4107081797004604247L;
    private static final char[] DEFAULT_PBE_KEY = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
    private static final int DEFAULT_SALT_SIZE = 8;
    private static final int DEFAULT_ITERATION_COUNT = 1000;
    private final String algorithm;
    private final char[] initialKeyMaterial;
    private final int iterationCount;
    private final byte[] salt;
    private final byte[] maskedPasswordBytes;
    private final byte[] initializationVector;

    private MaskedPasswordImpl(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, byte[] initializationVector, byte[] maskedPasswordBytes) throws InvalidKeySpecException {
        Assert.checkMinimumParameter((String)"iterationCount", (int)1, (int)iterationCount);
        this.algorithm = algorithm;
        this.initialKeyMaterial = initialKeyMaterial;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.maskedPasswordBytes = maskedPasswordBytes;
        this.initializationVector = initializationVector;
        this.unmask();
    }

    private MaskedPasswordImpl(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, char[] chars) throws InvalidKeySpecException {
        Assert.checkMinimumParameter((String)"iterationCount", (int)1, (int)iterationCount);
        this.algorithm = algorithm;
        this.initialKeyMaterial = initialKeyMaterial;
        this.iterationCount = iterationCount;
        this.salt = salt;
        try {
            Cipher cipher = this.getCipher(1, null);
            this.maskedPasswordBytes = cipher.doFinal(CodePointIterator.ofChars((char[])chars).asUtf8().drain());
            this.initializationVector = cipher.getIV();
        }
        catch (GeneralSecurityException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    MaskedPasswordImpl(String algorithm, MaskedPasswordSpec passwordSpec) throws InvalidKeySpecException {
        this(algorithm, (char[])passwordSpec.getInitialKeyMaterial().clone(), passwordSpec.getIterationCount(), (byte[])passwordSpec.getSalt().clone(), passwordSpec.getInitializationVector() == null ? null : (byte[])passwordSpec.getInitializationVector().clone(), (byte[])passwordSpec.getMaskedPasswordBytes().clone());
    }

    MaskedPasswordImpl(String algorithm, char[] clearPassword) throws InvalidKeySpecException {
        this(algorithm, DEFAULT_PBE_KEY, 1000, PasswordUtil.generateRandomSalt(8), clearPassword);
    }

    MaskedPasswordImpl(String algorithm, char[] clearPassword, MaskedPasswordAlgorithmSpec parameterSpec) throws InvalidKeySpecException {
        this(algorithm, (char[])parameterSpec.getInitialKeyMaterial().clone(), parameterSpec.getIterationCount(), (byte[])parameterSpec.getSalt().clone(), clearPassword);
    }

    MaskedPasswordImpl(String algorithm, char[] clearPassword, IteratedSaltedPasswordAlgorithmSpec parameterSpec) throws InvalidKeySpecException {
        this(algorithm, DEFAULT_PBE_KEY, parameterSpec.getIterationCount(), (byte[])parameterSpec.getSalt().clone(), clearPassword);
    }

    MaskedPasswordImpl(String algorithm, char[] clearPassword, SaltedPasswordAlgorithmSpec parameterSpec) throws InvalidKeySpecException {
        this(algorithm, DEFAULT_PBE_KEY, 1000, (byte[])parameterSpec.getSalt().clone(), clearPassword);
    }

    MaskedPasswordImpl(String algorithm, char[] clearPassword, IteratedPasswordAlgorithmSpec parameterSpec) throws InvalidKeySpecException {
        this(algorithm, DEFAULT_PBE_KEY, parameterSpec.getIterationCount(), PasswordUtil.generateRandomSalt(8), clearPassword);
    }

    MaskedPasswordImpl(String algorithm, ClearPasswordSpec keySpec) throws InvalidKeySpecException {
        this(algorithm, keySpec.getEncodedPassword());
    }

    MaskedPasswordImpl(MaskedPassword password) throws InvalidKeySpecException {
        this(password.getAlgorithm(), (char[])password.getInitialKeyMaterial().clone(), password.getIterationCount(), (byte[])password.getSalt().clone(), password.getInitializationVector() == null ? null : (byte[])password.getInitializationVector().clone(), (byte[])password.getMaskedPasswordBytes().clone());
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public char[] getInitialKeyMaterial() {
        return (char[])this.initialKeyMaterial.clone();
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    public byte[] getMaskedPasswordBytes() {
        return (byte[])this.maskedPasswordBytes.clone();
    }

    public byte[] getInitializationVector() {
        return this.initializationVector == null ? null : (byte[])this.initializationVector.clone();
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(MaskedPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new MaskedPasswordSpec((char[])this.initialKeyMaterial.clone(), this.iterationCount, (byte[])this.salt.clone(), (byte[])this.maskedPasswordBytes.clone())));
        }
        if (keySpecType.isAssignableFrom(ClearPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new ClearPasswordSpec(this.unmask())));
        }
        throw new InvalidKeySpecException();
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        try {
            return Arrays.equals(guess, this.unmask());
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(MaskedPasswordSpec.class) || keySpecType.isAssignableFrom(ClearPasswordSpec.class);
    }

    @Override
    public MaskedPasswordImpl clone() {
        return this;
    }

    private char[] unmask() throws InvalidKeySpecException {
        try {
            Cipher cipher = this.getCipher(2, this.initializationVector);
            return ByteIterator.ofBytes((byte[])cipher.doFinal(this.maskedPasswordBytes)).asUtf8String().drainToString().toCharArray();
        }
        catch (GeneralSecurityException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    private Cipher getCipher(int cipherMode, byte[] initializationVector) throws GeneralSecurityException {
        String pbeName = MaskedPassword.getPBEName((String)this.algorithm);
        Assert.assertNotNull((Object)pbeName);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeName);
        Cipher cipher = Cipher.getInstance(pbeName);
        IvParameterSpec parameterSpec = initializationVector == null ? null : new IvParameterSpec(initializationVector);
        PBEParameterSpec cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount, parameterSpec);
        PBEKeySpec keySpec = new PBEKeySpec(this.initialKeyMaterial);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        cipher.init(cipherMode, (Key)cipherKey, cipherSpec);
        return cipher;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)Arrays.hashCode(this.initialKeyMaterial), (int)Arrays.hashCode(this.salt)), (int)Arrays.hashCode(this.maskedPasswordBytes)), (int)this.iterationCount), (int)Arrays.hashCode(this.initializationVector)), (int)this.algorithm.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MaskedPasswordImpl)) {
            return false;
        }
        MaskedPasswordImpl other = (MaskedPasswordImpl)obj;
        return this.iterationCount == other.iterationCount && Arrays.equals(this.initialKeyMaterial, other.initialKeyMaterial) && MessageDigest.isEqual(this.salt, other.salt) && MessageDigest.isEqual(this.maskedPasswordBytes, other.maskedPasswordBytes) && MessageDigest.isEqual(this.initializationVector, other.initializationVector) && this.algorithm.equals(other.algorithm);
    }

    Object writeReplace() {
        return MaskedPassword.createRaw((String)this.algorithm, (char[])((char[])this.initialKeyMaterial.clone()), (int)this.iterationCount, (byte[])((byte[])this.salt.clone()), (byte[])((byte[])this.maskedPasswordBytes.clone()));
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }
}

