/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.encryption;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.common.codec.DecodeException;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.encryption.Common;
import org.wildfly.security.encryption.ElytronMessages;

public class CipherUtil {
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";

    public static String encrypt(String clearText, SecretKey secretKey) throws GeneralSecurityException {
        Assert.checkNotNullParam((String)"clearText", (Object)clearText);
        Assert.checkNotNullParam((String)"secretKey", (Object)secretKey);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, secretKey);
        byte[] cipherText = cipher.doFinal(clearText.getBytes(StandardCharsets.UTF_8));
        byte[] iv = cipher.getIV();
        byte[] result = new byte[iv.length + cipherText.length + 6];
        result[0] = 69;
        result[1] = 76;
        result[2] = 89;
        result[3] = 1;
        result[4] = 67;
        result[5] = (byte)iv.length;
        System.arraycopy(iv, 0, result, 6, iv.length);
        System.arraycopy(cipherText, 0, result, 6 + iv.length, cipherText.length);
        return ByteIterator.ofBytes((byte[])result).base64Encode().drainToString();
    }

    public static String decrypt(String token, SecretKey secretKey) throws GeneralSecurityException {
        Assert.checkNotNullParam((String)"secretKey", (Object)secretKey);
        try {
            ByteIterator byteIterator = CodePointIterator.ofString((String)((String)Assert.checkNotNullParam((String)"token", (Object)token))).base64Decode();
            byte[] prefixVersion = byteIterator.drain(5);
            if (prefixVersion.length < 4 || prefixVersion[0] != 69 || prefixVersion[1] != 76 || prefixVersion[2] != 89) {
                throw ElytronMessages.log.badKeyPrefix();
            }
            if (prefixVersion[3] != 1) {
                throw ElytronMessages.log.unsupportedVersion(prefixVersion[3], 1);
            }
            if (prefixVersion[4] != 67) {
                throw ElytronMessages.log.unexpectedTokenType(Common.toName((char)prefixVersion[4]), "CipherText");
            }
            int ivLength = byteIterator.next();
            byte[] iv = byteIterator.drain(ivLength);
            byte[] cipherText = byteIterator.drain();
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            IvParameterSpec spec = new IvParameterSpec(iv);
            cipher.init(2, (Key)secretKey, spec);
            byte[] clearText = cipher.doFinal(cipherText);
            return new String(clearText, StandardCharsets.UTF_8);
        }
        catch (DecodeException e) {
            throw ElytronMessages.log.unableToDecodeBase64Token(e);
        }
    }
}

