/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.MatchRule;

class MatchAbstractTypeAuthorityRule
extends MatchRule {
    private final String authority;

    MatchAbstractTypeAuthorityRule(MatchRule parent, String authority) {
        super(parent);
        this.authority = authority;
    }

    @Override
    public String getMatchAbstractTypeAuthority() {
        return this.authority;
    }

    @Override
    public boolean isTypeAuthorityMatched() {
        return true;
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        return this.authority.equals(abstractTypeAuthority) && super.matches(uri, abstractType, abstractTypeAuthority);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchAbstractTypeAuthorityRule(newParent, this.authority);
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.authority.equals(other.getMatchAbstractTypeAuthority()) && this.parentHalfEqual(other);
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)7879, (int)this.authority.hashCode());
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("abstractTypeAuthority=").append(this.authority).append(',');
    }
}

