/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.IOException;
import java.io.Serializable;
import java.net.PortUnreachableException;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.audit.ElytronMessages;
import org.wildfly.security.audit.EventPriority;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void endpointUnavaiable(String priority, String message, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.FATAL, cause, this.endpointUnavaiable$str(), (Object)priority, (Object)message);
    }

    protected String endpointUnavaiable$str() {
        return "ELY11001: Endpoint unable to handle SecurityEvent priority=%s, message=%s";
    }

    protected String invalidEventPriority$str() {
        return "ELY11002: Invalid EventPriority '%s' passed to AuditEndpoint.";
    }

    @Override
    public final IllegalArgumentException invalidEventPriority(EventPriority eventPriority) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidEventPriority$str(), new Object[]{eventPriority}));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void unableToRotateLogFile(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.unableToRotateLogFile$str(), new Object[0]);
    }

    protected String unableToRotateLogFile$str() {
        return "ELY11003: Unable to rotate log file";
    }

    protected String rotatingBySecondUnsupported$str() {
        return "ELY11004: Invalid suffix \"%s\" - rotating by second or millisecond is not supported";
    }

    @Override
    public final IllegalArgumentException rotatingBySecondUnsupported(String suffix) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.rotatingBySecondUnsupported$str(), suffix));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unableToAcceptEvent(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.FATAL, cause, this.unableToAcceptEvent$str(), new Object[0]);
    }

    protected String unableToAcceptEvent$str() {
        return "ELY11007: Endpoint unable to accept SecurityEvent.";
    }

    protected String syslogMaximumReconnectAttemptsReached$str() {
        return "ELY12001: The maximum reconnect attempts value of %s was reached. The syslog endpoint will be shutdown.";
    }

    @Override
    public final IOException syslogMaximumReconnectAttemptsReached(int reconnectAttempts) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.syslogMaximumReconnectAttemptsReached$str(), reconnectAttempts));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String udpPortUnavailable$str() {
        return "ELY12002: The configured UDP port is unavailable.";
    }

    @Override
    public final PortUnreachableException udpPortUnavailable(Throwable cause) {
        PortUnreachableException result = new PortUnreachableException(String.format(this.getLoggingLocale(), this.udpPortUnavailable$str(), new Object[0]));
        result.initCause(cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String badReconnectAttemptsNumber$str() {
        return "ELY12003: The reconnect attempts value of %s is invalid. Please use an integer value >= -1.";
    }

    @Override
    public final IllegalArgumentException badReconnectAttemptsNumber(int reconnectAttempts) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.badReconnectAttemptsNumber$str(), reconnectAttempts));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

