/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.OutputFormat;
import org.wildfly.glow.ScanArguments;

public class GlowConfig {
    static final String CLOUD_CONTEXT = "cloud";
    private String context = "bare-metal";
    private String profile;
    private Set<String> addOns = Set.of();
    private Set<String> spaces = Set.of();
    private String version;
    private boolean suggest;
    private Set<String> layersForJndi = Set.of();
    private Set<String> excludedArchives = Set.of();
    private boolean failsOnError = true;
    private boolean preview;
    private boolean verbose;
    private boolean ignoreDeployment;

    public Arguments toArguments(List<Path> lst, Path inProvisioning, String layersConfigurationFileName) {
        Set profiles = this.profile != null ? Set.of(this.profile) : Set.of();
        List<Object> deployments = this.ignoreDeployment ? Collections.emptyList() : lst;
        ScanArguments.Builder builder = Arguments.scanBuilder().setExecutionContext(this.context).setExecutionProfiles(profiles).setUserEnabledAddOns(this.addOns).setBinaries(deployments).setSuggest(this.suggest).setJndiLayers(this.getLayersForJndi()).setVersion(this.version).setTechPreview(this.preview).setExcludeArchivesFromScan(this.excludedArchives).setVerbose(this.verbose).setSpaces(this.spaces).setOutput(OutputFormat.PROVISIONING_XML);
        if (inProvisioning != null) {
            builder.setProvisoningXML(inProvisioning);
        }
        if (layersConfigurationFileName != null) {
            builder.setConfigName(layersConfigurationFileName);
        }
        return builder.build();
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public Set<String> getAddOns() {
        return this.addOns;
    }

    public void setAddOns(Set<String> addOns) {
        this.addOns = Set.copyOf(addOns);
    }

    public Set<String> getSpaces() {
        return this.spaces;
    }

    public void setSpaces(Set<String> spaces) {
        this.spaces = Set.copyOf(spaces);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isSuggest() {
        return this.suggest;
    }

    public void setSuggest(boolean suggest) {
        this.suggest = suggest;
    }

    public Set<String> getLayersForJndi() {
        return this.layersForJndi;
    }

    public void setLayersForJndi(Set<String> layersForJndi) {
        this.layersForJndi = Set.copyOf(layersForJndi);
    }

    public boolean isFailsOnError() {
        return this.failsOnError;
    }

    public void setFailsOnError(boolean failsOnError) {
        this.failsOnError = failsOnError;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public Set<String> getExcludedArchives() {
        return this.excludedArchives;
    }

    public void setExcludedArchives(Set<String> excludedArchives) {
        this.excludedArchives = Set.copyOf(excludedArchives);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setIgnoreDeployment(boolean ignoreDeployment) {
        this.ignoreDeployment = ignoreDeployment;
    }

    public boolean isIgnoreDeployment() {
        return this.ignoreDeployment;
    }
}

