/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.plugin.tools.cli.CLIWrapper;

public class LocalCLIExecutor {
    private static final String CLI_GROUP_ID = "org.wildfly.core";
    private static final String CLI_ARTIFACT_ID = "wildfly-cli";
    private static final String CLI_CLASSIFIER = "client";
    private static final String CLI_TYPE = "jar";
    private static final String WILDLY_CORE_VERSION_PROPERTY = "version.org.wildfly.core";
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private final ClassLoader originalCl;
    private final URLClassLoader cliCl;
    private final CLIWrapper cliWrapper;

    public LocalCLIExecutor(Path jbossHome, boolean resolveExpression, MavenRepoManager artifactResolver) throws Exception {
        URL[] cp = new URL[]{LocalCLIExecutor.resolveCLI(artifactResolver)};
        this.originalCl = Thread.currentThread().getContextClassLoader();
        this.cliCl = new URLClassLoader(cp, this.originalCl);
        Thread.currentThread().setContextClassLoader(this.cliCl);
        this.cliWrapper = new CLIWrapper(jbossHome, resolveExpression, (ClassLoader)this.cliCl);
    }

    private static URL resolveCLI(MavenRepoManager artifactResolver) throws Exception {
        URL[] cp = new URL[1];
        MavenArtifact mavenArtifact = new MavenArtifact();
        mavenArtifact.setGroupId(CLI_GROUP_ID);
        mavenArtifact.setArtifactId(CLI_ARTIFACT_ID);
        String version = LocalCLIExecutor.retrieveCoreVersion(artifactResolver);
        mavenArtifact.setVersion(version);
        mavenArtifact.setClassifier(CLI_CLASSIFIER);
        mavenArtifact.setExtension(CLI_TYPE);
        artifactResolver.resolve(mavenArtifact);
        return mavenArtifact.getPath().toUri().toURL();
    }

    public void bindClient(ModelControllerClient client) throws Exception {
        this.cliWrapper.bindClient(client);
    }

    public void executeBatch(Collection<String> commands) throws Exception {
        this.handle("batch");
        for (String c : commands) {
            this.handle(c);
        }
        this.handle("run-batch");
    }

    public void executeCommands(Iterable<String> commands, boolean failOnError) throws Exception {
        for (String cmd : commands) {
            if (failOnError) {
                this.handle(cmd);
                continue;
            }
            this.handleSafe(cmd);
        }
    }

    public void handle(String command) throws Exception {
        this.cliWrapper.handle(command);
    }

    public void handleSafe(String command) throws Exception {
        this.cliWrapper.handleSafe(command);
    }

    public String getOutput() {
        return this.cliWrapper.getOutput();
    }

    public void close() throws Exception {
        try {
            this.cliWrapper.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalCl);
            try {
                this.cliCl.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void execute(List<String> commands) throws Exception {
        for (String cmd : commands) {
            this.handle(cmd);
        }
    }

    private static String retrieveCoreVersion(MavenRepoManager artifactResolver) throws Exception {
        InputStream is = LocalCLIExecutor.class.getResourceAsStream("/META-INF/maven/plugin.xml");
        if (is == null) {
            throw new MojoExecutionException("Can't retrieve plugin descriptor");
        }
        PluginDescriptorBuilder builder = new PluginDescriptorBuilder();
        PluginDescriptor pluginDescriptor = builder.build((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        MavenArtifact mavenArtifact = new MavenArtifact();
        mavenArtifact.setGroupId(pluginDescriptor.getGroupId());
        mavenArtifact.setArtifactId(pluginDescriptor.getArtifactId());
        mavenArtifact.setVersion(pluginDescriptor.getVersion());
        mavenArtifact.setExtension("pom");
        artifactResolver.resolve(mavenArtifact);
        Model model = LocalCLIExecutor.readModel(mavenArtifact.getPath());
        Parent artifactParent = model.getParent();
        MavenArtifact parentArtifact = new MavenArtifact();
        parentArtifact.setGroupId(artifactParent.getGroupId());
        parentArtifact.setArtifactId(artifactParent.getArtifactId());
        parentArtifact.setVersion(artifactParent.getVersion());
        parentArtifact.setExtension("pom");
        artifactResolver.resolve(parentArtifact);
        Model parentModel = LocalCLIExecutor.readModel(parentArtifact.getPath());
        return parentModel.getProperties().getProperty(WILDLY_CORE_VERSION_PROPERTY);
    }

    private static Model readModel(Path pomXml) throws IOException {
        Model model;
        block8: {
            BufferedReader reader = Files.newBufferedReader(pomXml, LocalCLIExecutor.getEncoding(pomXml));
            try {
                MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
                Model model2 = xpp3Reader.read((Reader)reader);
                model2.setPomFile(pomXml.toFile());
                model = model2;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException ex) {
                    throw new IOException("Failed to parse artifact POM model", ex);
                }
            }
            reader.close();
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset getEncoding(Path pomXml) throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        try (FileReader fileReader = new FileReader(pomXml.toFile());
             XMLStreamReader xmlReader = XML_INPUT_FACTORY.createXMLStreamReader(fileReader);){
            String encoding = xmlReader.getCharacterEncodingScheme();
            if (encoding != null) {
                charset = Charset.forName(encoding);
            }
        }
        catch (XMLStreamException ex) {
            throw new IOException("Failed to retrieve encoding for " + String.valueOf(pomXml), ex);
        }
        return charset;
    }
}

