/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.ServerOperations;
import org.wildfly.plugin.tools.server.ServerManager;

@Mojo(name="shutdown")
public class ShutdownMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="false", property="wildfly.reload")
    private boolean reload;
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping server shutdown");
            return;
        }
        try (ModelControllerClient client = this.createClient();){
            if (ServerManager.isRunning((ModelControllerClient)client)) {
                ServerManager serverManager = (ServerManager)ServerManager.builder().client(client).build().get(this.timeout, TimeUnit.SECONDS);
                if (this.reload) {
                    if (serverManager.containerDescription().isDomain()) {
                        client.execute(ServerOperations.createOperation((String)"reload-servers"));
                    } else {
                        client.execute(ServerOperations.createOperation((String)"reload"));
                    }
                    serverManager.waitFor((long)this.timeout, TimeUnit.SECONDS);
                } else {
                    serverManager.shutdown();
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException ignore) {
                    ignore.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Please make sure a server is running before executing goal %s. Reason: %s", this.goal(), e.getMessage()), (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s. Reason: %s", this.goal(), e.getMessage()), e);
        }
    }

    @Override
    public String goal() {
        return "shutdown";
    }
}

