/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment.resource;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.MavenModelControllerClientConfiguration;
import org.wildfly.plugin.common.ServerOperations;
import org.wildfly.plugin.core.ServerHelper;
import org.wildfly.plugin.deployment.domain.Domain;
import org.wildfly.plugin.deployment.resource.Resource;

@Mojo(name="add-resource", threadSafe=true)
public class AddResourceMojo
extends AbstractServerConnection {
    public static final String GOAL = "add-resource";
    @Deprecated
    @Parameter
    private Domain domain;
    @Parameter(property="wildfly.profiles")
    private List<String> profiles;
    @Parameter
    private String address;
    @Parameter
    private Resource[] resources;
    @Parameter(defaultValue="true", property="add-resource.force")
    private boolean force;
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Inject
    private CommandExecutor commandExecutor;

    @Override
    public String goal() {
        return GOAL;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping add-resource with address %s", this.address));
            return;
        }
        if (this.jbossHome != null && !ServerHelper.isValidHomeDirectory((String)this.jbossHome)) {
            throw new MojoFailureException("Invalid JBoss Home directory is not valid: " + this.jbossHome);
        }
        try (ModelControllerClient client = this.createClient();
             MavenModelControllerClientConfiguration configuration = this.getClientConfiguration();){
            if (this.resources != null && this.resources.length > 0) {
                this.processResources(client, configuration, this.resources);
            } else {
                this.getLog().warn((CharSequence)"No resources were provided.");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s. Reason: %s", this.goal(), e.getMessage()), e);
        }
    }

    private void processResources(ModelControllerClient client, MavenModelControllerClientConfiguration configuration, Resource ... resources) throws IOException {
        Collection<String> profiles = this.getProfiles();
        boolean isDomain = ServerHelper.isDomainServer((ModelControllerClient)client);
        for (Resource resource : resources) {
            if (isDomain && profiles.isEmpty()) {
                throw new IllegalStateException("Cannot add resources when no profiles were defined.");
            }
            if (isDomain) {
                if (profiles.isEmpty()) {
                    throw new IllegalStateException("Cannot add resources when no profiles were defined.");
                }
                for (String profile : profiles) {
                    Operations.CompositeOperationBuilder compositeOperationBuilder;
                    if (!this.addCompositeResource(profile, client, resource, this.address, compositeOperationBuilder = Operations.CompositeOperationBuilder.create(), true)) continue;
                    if (resource.hasBeforeAddCommands()) {
                        this.commandExecutor.execute(configuration, this.jbossHome, resource.getBeforeAdd());
                    }
                    this.reportFailure(client.execute(compositeOperationBuilder.build()));
                    if (!resource.hasAfterAddCommands()) continue;
                    this.commandExecutor.execute(configuration, this.jbossHome, resource.getAfterAdd());
                }
                continue;
            }
            Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
            if (!this.addCompositeResource(null, client, resource, this.address, compositeOperationBuilder, true)) continue;
            if (resource.hasBeforeAddCommands()) {
                this.commandExecutor.execute(configuration, this.jbossHome, resource.getBeforeAdd());
            }
            this.reportFailure(client.execute(compositeOperationBuilder.build()));
            if (!resource.hasAfterAddCommands()) continue;
            this.commandExecutor.execute(configuration, this.jbossHome, resource.getAfterAdd());
        }
    }

    private boolean addCompositeResource(String profileName, ModelControllerClient client, Resource resource, String parentAddress, Operations.CompositeOperationBuilder compositeOp, boolean checkExistence) throws IOException {
        String inputAddress = parentAddress == null ? resource.getAddress() : (parentAddress.equals(resource.getAddress()) ? resource.getAddress() : (resource.getAddress() == null ? parentAddress : String.format("%s,%s", parentAddress, resource.getAddress())));
        if (inputAddress == null) {
            throw new RuntimeException("You must specify the address to add the resource to.");
        }
        ModelNode address = this.parseAddress(profileName, inputAddress);
        if (checkExistence) {
            boolean exists = this.resourceExists(address, client);
            if (resource.isAddIfAbsent() && exists) {
                return false;
            }
            if (exists && this.force) {
                this.reportFailure(client.execute(ServerOperations.createRemoveOperation(address, true)));
            } else if (exists) {
                throw new RuntimeException(String.format("Resource %s already exists.", address));
            }
        }
        compositeOp.addStep(this.buildAddOperation(address, resource.getProperties()));
        if (resource.getResources() != null) {
            String resourceAddress = resource.getAddress();
            String addr = parentAddress != null && resourceAddress != null ? parentAddress + "," + resourceAddress : (parentAddress != null ? parentAddress : (resourceAddress != null ? resourceAddress : null));
            for (Resource r : resource.getResources()) {
                this.addCompositeResource(profileName, client, r, addr, compositeOp, false);
            }
        }
        return true;
    }

    private ModelNode buildAddOperation(ModelNode address, Map<String, String> properties) {
        ModelNode op = ServerOperations.createAddOperation((ModelNode)address);
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            String value;
            String[] props = prop.getKey().split(",");
            if (props.length == 0) {
                throw new RuntimeException("Invalid property " + prop);
            }
            ModelNode node = op;
            for (int i = 0; i < props.length - 1; ++i) {
                node = node.get(props[i]);
            }
            String string = value = prop.getValue() == null ? "" : prop.getValue();
            if (value.startsWith("!!")) {
                this.handleDmrString(node, props[props.length - 1], value);
                continue;
            }
            node.get(props[props.length - 1]).set(value);
        }
        return op;
    }

    private boolean resourceExists(ModelNode address, ModelControllerClient client) throws IOException {
        ModelNode resources;
        Property childAddress = ServerOperations.getChildAddress(address);
        ModelNode parentAddress = ServerOperations.getParentAddress(address);
        ModelNode r = client.execute(ServerOperations.createOperation("read-resource", parentAddress, false));
        this.reportFailure(r);
        boolean found = false;
        String name = childAddress.getName();
        if (ServerOperations.isSuccessfulOutcome((ModelNode)r) && (resources = ServerOperations.readResult((ModelNode)r).get(name)).isDefined()) {
            for (ModelNode dataSource : resources.asList()) {
                if (!dataSource.asProperty().getName().equals(childAddress.getValue().asString())) continue;
                found = true;
            }
        }
        return found;
    }

    private void handleDmrString(ModelNode node, String name, String value) {
        String realValue = value.substring(2);
        node.get(name).set(ModelNode.fromString((String)realValue));
    }

    private ModelNode parseAddress(String profileName, String inputAddress) {
        String[] parts;
        ModelNode result = new ModelNode();
        if (profileName != null) {
            result.add("profile", profileName);
        }
        for (String part : parts = inputAddress.split(",")) {
            String[] address = part.split("=");
            if (address.length != 2) {
                throw new RuntimeException(part + " is not a valid address segment");
            }
            result.add(address[0], address[1]);
        }
        return result;
    }

    private void reportFailure(ModelNode result) {
        if (!ServerOperations.isSuccessfulOutcome((ModelNode)result)) {
            throw new RuntimeException(ServerOperations.getFailureDescriptionAsString(result));
        }
    }

    private Collection<String> getProfiles() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.domain != null) {
            result.addAll(this.domain.getProfiles());
        }
        if (this.profiles != null) {
            result.addAll(this.profiles);
        }
        return result;
    }
}

