/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.licenses;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.wildfly.maven.plugins.licenses.MavenProjectDependenciesConfiguration;

@Singleton
public class DependenciesResolver
extends AbstractLogEnabled {
    public static final String INVALID_PATTERN_MESSAGE = "The pattern specified by expression <%s> seems to be invalid.";
    @Inject
    private MavenProjectBuilder mavenProjectBuilder;

    public <R> SortedMap<String, R> loadDependenciesAndConvertThem(MavenProject project, MavenProjectDependenciesConfiguration configuration, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, SortedMap<String, MavenProject> cache, Function<MavenProject, R> convertFunction) {
        Pattern includedGroupPattern = this.isEmpty(configuration.includedGroups) ? null : Pattern.compile(configuration.includedGroups);
        Pattern includedArtifactPattern = this.isEmpty(configuration.includedArtifacts) ? null : Pattern.compile(configuration.includedArtifacts);
        Pattern excludedGroupPattern = this.isEmpty(configuration.excludedGroups) ? null : Pattern.compile(configuration.excludedGroups);
        Pattern excludedArtifactPattern = this.isEmpty(configuration.excludedArtifacts) ? null : Pattern.compile(configuration.excludedArtifacts);
        boolean matchInclusions = includedGroupPattern != null || includedArtifactPattern != null;
        boolean matchExclusions = excludedGroupPattern != null || excludedArtifactPattern != null;
        Set depArtifacts = configuration.includeTransitiveDependencies ? project.getArtifacts() : project.getDependencyArtifacts();
        if (configuration.includeSelfArtifact) {
            depArtifacts.add(project.getArtifact());
        }
        List<String> includedScopes = configuration.includedScopes;
        List<String> excludeScopes = configuration.excludedScopes;
        boolean verbose = configuration.verbose;
        TreeMap<String, R> result = new TreeMap<String, R>();
        Logger log = this.getLogger();
        for (Object o : depArtifacts) {
            Artifact artifact = (Artifact)o;
            String id = this.getArtifactId(artifact);
            if (verbose) {
                log.info("detected artifact " + id);
            }
            if (!configuration.includeOptionalDependencies && artifact.isOptional()) {
                if (!verbose) continue;
                log.info("skip optional artifact " + id);
                continue;
            }
            String scope = artifact.getScope();
            if (this.isNotEmptyCollection(includedScopes) && !includedScopes.contains(scope)) {
                if (!verbose) continue;
                log.info("skip artifact " + id + " - not in included scopes");
                continue;
            }
            if (excludeScopes.contains(scope)) {
                if (!verbose) continue;
                log.info("skip artifact " + id + " - in excluded scope " + scope);
                continue;
            }
            boolean isToInclude = this.matchesIncluded(artifact, includedGroupPattern, includedArtifactPattern);
            if (!isToInclude) {
                if (!verbose) continue;
                log.info("skip artifact " + id + " - not in included artifactId / groupId patterns");
                continue;
            }
            boolean isToExclude = this.matchesExcluded(artifact, excludedGroupPattern, excludedArtifactPattern);
            if (isToExclude) {
                if (!verbose) continue;
                log.info("skip artifact " + id + " - in excluded artifactId / groupId patterns");
                continue;
            }
            MavenProject depMavenProject = this.getDependencyMavenProject(localRepository, remoteRepositories, cache, verbose, artifact, log, id);
            if (depMavenProject == null) continue;
            result.put(id, convertFunction.apply(depMavenProject));
        }
        return result;
    }

    private MavenProject getDependencyMavenProject(ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, SortedMap<String, MavenProject> cache, boolean verbose, Artifact artifact, Logger log, String id) {
        MavenProject depMavenProject = null;
        if (cache != null && (depMavenProject = (MavenProject)cache.get(id)) != null) {
            if (verbose) {
                log.info("add dependency [" + id + "] (from cache)");
            }
            return depMavenProject;
        }
        try {
            depMavenProject = this.mavenProjectBuilder.buildFromRepository(artifact, remoteRepositories, localRepository, true);
            depMavenProject.getArtifact().setScope(artifact.getScope());
        }
        catch (ProjectBuildingException e) {
            log.warn("Unable to obtain POM for artifact : " + artifact, (Throwable)e);
            return null;
        }
        if (verbose) {
            log.info("add dependency [" + id + "]");
        }
        if (cache != null) {
            cache.put(id, depMavenProject);
        }
        return depMavenProject;
    }

    private boolean matchesIncluded(Artifact project, Pattern includedGroupPattern, Pattern includedArtifactPattern) {
        Matcher matchGroupId;
        Logger log = this.getLogger();
        if (includedArtifactPattern == null && includedGroupPattern == null) {
            return true;
        }
        if (includedGroupPattern != null) {
            try {
                matchGroupId = includedGroupPattern.matcher(project.getGroupId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Include " + project.getGroupId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, includedGroupPattern.pattern()));
            }
        }
        if (includedArtifactPattern != null) {
            try {
                matchGroupId = includedArtifactPattern.matcher(project.getArtifactId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Include " + project.getArtifactId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, includedArtifactPattern.pattern()));
            }
        }
        return false;
    }

    protected boolean matchesExcluded(Artifact project, Pattern excludedGroupPattern, Pattern excludedArtifactPattern) {
        Matcher matchGroupId;
        Logger log = this.getLogger();
        if (excludedGroupPattern == null && excludedArtifactPattern == null) {
            return false;
        }
        if (excludedGroupPattern != null) {
            try {
                matchGroupId = excludedGroupPattern.matcher(project.getGroupId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exclude " + project.getGroupId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, excludedGroupPattern.pattern()));
            }
        }
        if (excludedArtifactPattern != null) {
            try {
                matchGroupId = excludedArtifactPattern.matcher(project.getArtifactId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exclude " + project.getArtifactId());
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                log.warn(String.format(INVALID_PATTERN_MESSAGE, excludedArtifactPattern.pattern()));
            }
        }
        return false;
    }

    boolean isNotEmptyCollection(Collection coll) {
        return coll != null && !coll.isEmpty();
    }

    String getArtifactId(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId());
        sb.append("--");
        sb.append(artifact.getArtifactId());
        sb.append("--");
        sb.append(artifact.getVersion());
        return sb.toString();
    }

    boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

