/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.cloud.annotation.processor;

import io.dekorate.kubernetes.annotation.Port;
import io.dekorate.processor.AbstractAnnotationProcessor;
import io.dekorate.project.AptProjectFactory;
import io.dekorate.s2i.annotation.S2iBuild;
import io.dekorate.utils.Maps;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

abstract class WildFlyDefaultsAbstractAnnotationProcessor
extends AbstractAnnotationProcessor {
    private static final String DOCKER_FILE = "Dockerfile";
    private static final String DOCKER_FILE_RELATIVE_TO_TARGET = "docker/Dockerfile";
    private static final String GENERATED_DOCKER_FILE_LOCATION = "target/docker/Dockerfile";
    private static final String CLI_SCRIPT_SOURCE = "src/main/cli-script/init.cli";
    private static final String CLI_SCRIPT_IN_IMAGE = "cli-script/init.cli";
    private static final String CLI_LAUNCH_SCRIPT_VAR = "CLI_LAUNCH_SCRIPT";
    private final AtomicReference<ProcessingEnvironment> processingEnvRef = new AtomicReference();
    private final AtomicBoolean s2iWarningLogged = new AtomicBoolean();

    WildFlyDefaultsAbstractAnnotationProcessor() {
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingEnvRef.set(processingEnv);
        if (!this.projectExists()) {
            this.setProject(AptProjectFactory.create((ProcessingEnvironment)processingEnv));
        }
    }

    abstract Class<? extends Annotation> getAnnotationClass();

    abstract Port[] getPorts(Element var1);

    abstract String getEnvVarPrefix();

    abstract String getPortPrefix();

    void addAddtionalProperties(Map<String, Object> inputProperties, S2iBuild s2iBuild) {
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.getSession().close();
            return true;
        }
        this.processingEnv = this.processingEnvRef.get();
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, ((Object)((Object)this)).getClass().getSimpleName() + " looking for annotations: " + annotations);
        for (TypeElement typeElement : annotations) {
            boolean found = false;
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                messager.printMessage(Diagnostic.Kind.NOTE, ((Object)((Object)this)).getClass().getSimpleName() + " found @" + this.getAnnotationClass().getSimpleName() + " on: " + element.toString());
                if (found) {
                    messager.printMessage(Diagnostic.Kind.ERROR, String.format("Found more than one @%s class found on the classpath.", this.getAnnotationClass().getSimpleName()), typeElement);
                }
                found = true;
                Port[] ports = this.getPorts(element);
                Path targetDirectory = this.determineTargetDirectory(element);
                Path cliScript = targetDirectory.getParent().resolve(CLI_SCRIPT_SOURCE).normalize().toAbsolutePath();
                if (Files.exists(cliScript, new LinkOption[0])) {
                    messager.printMessage(Diagnostic.Kind.NOTE, String.format("Found %s. Will add it to the image.", cliScript));
                } else {
                    messager.printMessage(Diagnostic.Kind.NOTE, String.format("No CLI script found at %s. Not adding to image", cliScript));
                    cliScript = null;
                }
                S2iBuild s2iBuild = this.getS2iBuildAnnotation(roundEnv);
                boolean suppliedDockerFile = this.isDockerFileSupplied(targetDirectory);
                if (!suppliedDockerFile) {
                    this.generateDockerFile(element, targetDirectory, cliScript);
                }
                this.addDefaults(element, cliScript != null, ports, !suppliedDockerFile, s2iBuild);
            }
        }
        return false;
    }

    private void addDefaults(Element mainClass, boolean cliScriptAdded, Port[] ports, boolean useGenerateDockerFile, S2iBuild s2iBuild) {
        HashMap<String, Object> inputProperties = new HashMap<String, Object>();
        if (cliScriptAdded) {
            inputProperties.put(this.getEnvVarPrefix() + "env-vars[0].name", CLI_LAUNCH_SCRIPT_VAR);
            inputProperties.put(this.getEnvVarPrefix() + "env-vars[0].value", CLI_SCRIPT_IN_IMAGE);
        }
        inputProperties.put(this.getPortPrefix() + "ports[0].name", "http");
        inputProperties.put(this.getPortPrefix() + "ports[0].containerPort", "8080");
        String nodePort = this.getNodePort("http", ports);
        if (nodePort != null) {
            inputProperties.put(this.getPortPrefix() + "ports[0].nodePort", nodePort);
        }
        inputProperties.put(this.getPortPrefix() + "ports[1].name", "admin");
        inputProperties.put(this.getPortPrefix() + "ports[1].containerPort", "9990");
        nodePort = this.getNodePort("admin", ports);
        if (nodePort != null) {
            inputProperties.put(this.getPortPrefix() + "ports[1].nodePort", nodePort);
        }
        if (s2iBuild == null) {
            this.setPropertyWithDefault(inputProperties, "dekorate.s2i.enabled", "false");
        }
        if (useGenerateDockerFile) {
            inputProperties.put("dekorate.docker.docker-file", GENERATED_DOCKER_FILE_LOCATION);
        }
        this.addAddtionalProperties(inputProperties, s2iBuild);
        Map properties = Maps.fromProperties(inputProperties);
        this.getSession().addPropertyConfiguration(properties);
    }

    private void setPropertyWithDefault(Map<String, Object> inputProperties, String propertyName, String defaultValue) {
        String value = System.getProperty(propertyName);
        if (value == null) {
            value = defaultValue;
        }
        inputProperties.put(propertyName, value);
    }

    private String getNodePort(String name, Port[] ports) {
        for (Port port : ports) {
            if (!name.equals(port.name()) || port.nodePort() == 0) continue;
            return "" + port.nodePort();
        }
        return null;
    }

    private Path determineTargetDirectory(Element mainClass) {
        String qualifiedName = ((TypeElement)mainClass).getQualifiedName().toString();
        String packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
        Path path = null;
        try {
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "tmp", mainClass.getSimpleName() + ".class");
            path = Paths.get(fileObject.toUri());
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), mainClass);
        }
        while (path != null && !path.getFileName().toString().equals("target")) {
            path = path.getParent();
        }
        return path;
    }

    private void generateDockerFile(Element mainClass, Path targetDirectory, Path cliScript) {
        String imageName = System.getProperty("wildfly.cloud.test.base.image.name");
        if (imageName == null || imageName.trim().isBlank()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "No image name set via the 'wildfly.cloud.test.base.image.name' property in the test module pom", mainClass);
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("FROM " + imageName);
        lines.add("COPY --chown=jboss:root target/ROOT.war $JBOSS_HOME/standalone/deployments");
        lines.add("RUN chmod -R ug+rwX $JBOSS_HOME");
        if (cliScript != null) {
            lines.add("COPY --chown=jboss:root src/main/cli-script/init.cli $JBOSS_HOME/cli-script/init.cli");
        }
        try {
            Path dockerFile = targetDirectory.resolve(DOCKER_FILE_RELATIVE_TO_TARGET);
            if (Files.exists(dockerFile, new LinkOption[0])) {
                Files.delete(dockerFile);
            }
            if (!Files.exists(dockerFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(dockerFile.getParent(), new FileAttribute[0]);
            }
            Files.createFile(dockerFile, new FileAttribute[0]);
            Files.write(dockerFile, lines, new OpenOption[0]);
            if (cliScript != null) {
                Files.copy(cliScript, dockerFile.getParent().resolve(cliScript.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to generate Dockerfile: " + e.getMessage(), mainClass);
        }
    }

    private boolean isDockerFileSupplied(Path targetDirectory) {
        Path dockerFile = targetDirectory.getParent().resolve(DOCKER_FILE);
        if (!Files.exists(dockerFile, new LinkOption[0])) {
            return false;
        }
        try {
            List<String> lines = Files.readAllLines(dockerFile);
            for (String line : lines) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                return true;
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read the Dockerfile: " + e.getMessage());
        }
        return false;
    }

    private S2iBuild getS2iBuildAnnotation(RoundEnvironment roundEnv) {
        TypeElement dockerBuild = this.processingEnv.getElementUtils().getTypeElement(S2iBuild.class.getName());
        Set<? extends Element> s2iBuildClasses = roundEnv.getElementsAnnotatedWith(dockerBuild);
        if (s2iBuildClasses.size() > 1) {
            if (this.s2iWarningLogged.compareAndSet(false, true)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Found more than one class annotated with @S2iBuild: ");
                for (Element element : s2iBuildClasses) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Annotated with @S2iBuild", element);
                }
            }
        } else if (s2iBuildClasses.size() == 1) {
            return s2iBuildClasses.iterator().next().getAnnotation(S2iBuild.class);
        }
        return null;
    }
}

