/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.wildfly.build.common.model.ConfigXMLWriter11;
import org.wildfly.build.common.model.CopyArtifactsXMLWriter10;
import org.wildfly.build.common.model.FilePermissionsXMLWriter10;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.FeaturePackDescription;
import org.wildfly.build.pack.model.FeaturePackDescriptionXMLParser10;
import org.wildfly.build.util.xml.AttributeValue;
import org.wildfly.build.util.xml.ElementNode;
import org.wildfly.build.util.xml.FormattingXMLStreamWriter;

public class FeaturePackDescriptionXMLWriter11 {
    public static final FeaturePackDescriptionXMLWriter11 INSTANCE = new FeaturePackDescriptionXMLWriter11();

    private FeaturePackDescriptionXMLWriter11() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FeaturePackDescription featurePackDescription, File outputFile) throws XMLStreamException, IOException {
        ElementNode featurePackElementNode = new ElementNode(null, FeaturePackDescriptionXMLParser10.Element.FEATURE_PACK.getLocalName(), "urn:wildfly:feature-pack:1.1");
        this.processDependencies(featurePackDescription.getDependencies(), featurePackElementNode);
        this.processArtifactVersions(featurePackDescription.getArtifactVersions(), featurePackElementNode);
        ConfigXMLWriter11.INSTANCE.write(featurePackDescription.getConfig(), featurePackElementNode);
        CopyArtifactsXMLWriter10.INSTANCE.write(featurePackDescription.getCopyArtifacts(), featurePackElementNode);
        FilePermissionsXMLWriter10.INSTANCE.write(featurePackDescription.getFilePermissions(), featurePackElementNode);
        FormattingXMLStreamWriter writer = new FormattingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(new BufferedWriter(new FileWriter(outputFile))));
        try {
            writer.writeStartDocument();
            featurePackElementNode.marshall(writer);
            writer.writeEndDocument();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void processDependencies(List<String> dependencies, ElementNode featurePackElementNode) {
        if (!dependencies.isEmpty()) {
            ElementNode dependenciesElementNode = new ElementNode(featurePackElementNode, FeaturePackDescriptionXMLParser10.Element.DEPENDENCIES.getLocalName());
            for (String artifactName : dependencies) {
                ElementNode artifactElementNode = new ElementNode(dependenciesElementNode, FeaturePackDescriptionXMLParser10.Element.ARTIFACT.getLocalName());
                artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.NAME.getLocalName(), new AttributeValue(artifactName));
                dependenciesElementNode.addChild(artifactElementNode);
            }
            featurePackElementNode.addChild(dependenciesElementNode);
        }
    }

    protected void processArtifactVersions(Set<Artifact> artifactVersions, ElementNode featurePackElementNode) {
        if (!artifactVersions.isEmpty()) {
            ElementNode versionsElementNode = new ElementNode(featurePackElementNode, FeaturePackDescriptionXMLParser10.Element.ARTIFACT_VERSIONS.getLocalName());
            for (Artifact artifact : artifactVersions) {
                this.processArtifact(artifact, versionsElementNode);
            }
            featurePackElementNode.addChild(versionsElementNode);
        }
    }

    protected void processArtifact(Artifact artifact, ElementNode versionsElementNode) {
        ElementNode artifactElementNode = new ElementNode(versionsElementNode, FeaturePackDescriptionXMLParser10.Element.ARTIFACT.getLocalName());
        Artifact.GACE GACE2 = artifact.getGACE();
        artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.GROUP_ID.getLocalName(), new AttributeValue(GACE2.getGroupId()));
        artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.ARTIFACT_ID.getLocalName(), new AttributeValue(GACE2.getArtifactId()));
        artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.VERSION.getLocalName(), new AttributeValue(artifact.getVersion()));
        if (GACE2.getClassifier() != null) {
            artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.CLASSIFIER.getLocalName(), new AttributeValue(GACE2.getClassifier()));
        }
        if (GACE2.getExtension() != null) {
            artifactElementNode.addAttribute(FeaturePackDescriptionXMLParser10.Attribute.EXTENSION.getLocalName(), new AttributeValue(GACE2.getExtension()));
        }
        versionsElementNode.addChild(artifactElementNode);
    }
}

