/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.common.model;

import java.util.Map;
import org.wildfly.build.common.model.Config;
import org.wildfly.build.common.model.ConfigFile;
import org.wildfly.build.common.model.ConfigModelParser10;
import org.wildfly.build.util.xml.AttributeValue;
import org.wildfly.build.util.xml.ElementNode;

public class ConfigXMLWriter11 {
    public static final ConfigXMLWriter11 INSTANCE = new ConfigXMLWriter11();

    private ConfigXMLWriter11() {
    }

    public void write(Config config, ElementNode parentElementNode) {
        if (!config.getStandaloneConfigFiles().isEmpty() || !config.getDomainConfigFiles().isEmpty()) {
            ElementNode configElementNode = new ElementNode(parentElementNode, "config");
            for (ConfigFile configFile : config.getStandaloneConfigFiles()) {
                ElementNode standaloneElementNode = new ElementNode(parentElementNode, ConfigModelParser10.Element.STANDALONE.getLocalName());
                this.writeConfigFile(configFile, standaloneElementNode);
                configElementNode.addChild(standaloneElementNode);
            }
            for (ConfigFile configFile : config.getDomainConfigFiles()) {
                ElementNode domainElementNode = new ElementNode(parentElementNode, ConfigModelParser10.Element.DOMAIN.getLocalName());
                this.writeConfigFile(configFile, domainElementNode);
                configElementNode.addChild(domainElementNode);
            }
            for (ConfigFile configFile : config.getHostConfigFiles()) {
                ElementNode hostElementNode = new ElementNode(parentElementNode, ConfigModelParser10.Element.HOST.getLocalName());
                this.writeConfigFile(configFile, hostElementNode);
                configElementNode.addChild(hostElementNode);
            }
            parentElementNode.addChild(configElementNode);
        }
    }

    protected void writeConfigFile(ConfigFile configFile, ElementNode configElementNode) {
        for (Map.Entry<String, String> property : configFile.getProperties().entrySet()) {
            ElementNode propertyElementNode = new ElementNode(configElementNode, ConfigModelParser10.Element.PROPERTY.getLocalName());
            propertyElementNode.addAttribute(ConfigModelParser10.Attribute.NAME.getLocalName(), new AttributeValue(property.getKey()));
            propertyElementNode.addAttribute(ConfigModelParser10.Attribute.VALUE.getLocalName(), new AttributeValue(property.getValue()));
            configElementNode.addChild(propertyElementNode);
        }
        configElementNode.addAttribute(ConfigModelParser10.Attribute.TEMPLATE.getLocalName(), new AttributeValue(configFile.getTemplate()));
        configElementNode.addAttribute(ConfigModelParser10.Attribute.SUBSYSTEMS.getLocalName(), new AttributeValue(configFile.getSubsystems()));
        configElementNode.addAttribute(ConfigModelParser10.Attribute.OUTPUT_FILE.getLocalName(), new AttributeValue(configFile.getOutputFile()));
    }
}

