/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.text;

import org.wikbook.text.Clip;
import org.wikbook.text.Position;

public class TextArea {
    private String s;

    public TextArea(String s) {
        if (s == null) {
            throw new NullPointerException("No null string accepted");
        }
        this.s = s;
    }

    public String clip(Position from, Position to) {
        int _to;
        int _from = this.offset(from);
        if (_from > (_to = this.offset(to))) {
            throw new IllegalArgumentException("Wrong clipping Positions");
        }
        Position __to = this.position(_to);
        StringBuffer sb = new StringBuffer();
        sb.append(this.s.substring(_from, _to));
        for (int c = __to.column; c < to.column; ++c) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public TextArea insert(Position position, CharSequence seq) {
        int offset = this.offset(Position.get(position.line, 0));
        StringBuffer sb = new StringBuffer();
        sb.append(this.s.substring(0, offset));
        int nextCR = this.s.indexOf(10, offset);
        if (nextCR == -1) {
            nextCR = this.s.length();
        }
        for (int i = 0; i < position.column; ++i) {
            if (offset < nextCR) {
                sb.append(this.s.charAt(offset++));
                continue;
            }
            sb.append(' ');
        }
        sb.append(seq);
        sb.append(this.s.substring(offset));
        this.s = sb.toString();
        return this;
    }

    public TextArea remove(Position from, Position to) {
        return this;
    }

    public String getText() {
        return this.s;
    }

    public String clip(Clip clip) {
        return this.clip(clip.getFrom(), clip.getTo());
    }

    public Position length() {
        return this.position(this.s.length());
    }

    public String clip(Position from) {
        int _to;
        int _from = this.offset(from);
        if (_from > (_to = this.s.length())) {
            throw new IllegalArgumentException("Wrong clipping Positions");
        }
        return this.s.substring(_from, _to);
    }

    public Position position(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (offset > this.s.length()) {
            throw new IllegalArgumentException();
        }
        int line = 0;
        int column = 0;
        for (int i = 0; i < offset; ++i) {
            char c = this.s.charAt(i);
            if (c == '\n') {
                column = 0;
                ++line;
                continue;
            }
            ++column;
        }
        return Position.get(line, column);
    }

    public int offset(Position position) throws NullPointerException {
        if (position == null) {
            throw new NullPointerException();
        }
        int offset = 0;
        int lineOffset = position.line;
        int columnOffset = position.column;
        while (lineOffset != 0 || columnOffset != 0) {
            if (offset >= this.s.length()) {
                throw new IllegalArgumentException();
            }
            char next = this.s.charAt(offset);
            if (lineOffset > 0) {
                if (next == '\n') {
                    --lineOffset;
                }
            } else {
                if (next == '\n' && columnOffset > 0) break;
                --columnOffset;
            }
            ++offset;
        }
        return offset;
    }
}

