/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.codesource;

import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.wikbook.codesource.CodeSourceBuilderContext;
import org.wikbook.codesource.CodeSourceException;
import org.wikbook.codesource.CompilationUnitVisitor;
import org.wikbook.codesource.NoSuchSourceException;
import org.wikbook.codesource.TypeSource;
import org.wikbook.codesource.Visit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeSourceBuilder {
    final CodeSourceBuilderContext context;

    public CodeSourceBuilder(CodeSourceBuilderContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
    }

    public CodeSourceBuilder() {
        this(new CodeSourceBuilderContext(){

            public InputStream getResource(String path) {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            }
        });
    }

    public TypeSource buildClass(Class<?> clazz) throws CodeSourceException {
        Class<?> enclosing;
        Class<?> top = clazz;
        while ((enclosing = top.getEnclosingClass()) != null) {
            top = enclosing;
        }
        Collection<TypeSource> types = this.buildCompilationUnit(top.getName().replace(".", "/") + ".java");
        for (TypeSource type : types) {
            if (!type.getName().equals(type.getName())) continue;
            return type;
        }
        return null;
    }

    public TypeSource buildClass(String fqn) throws CodeSourceException {
        String current = fqn;
        while (true) {
            try {
                TypeSource type;
                block3: while (true) {
                    String path = current.replace('.', '/') + ".java";
                    Collection<TypeSource> types = this.buildCompilationUnit(path);
                    Iterator<TypeSource> i$ = types.iterator();
                    do {
                        if (!i$.hasNext()) continue block3;
                    } while (!(type = i$.next()).getName().equals(fqn));
                    break;
                }
                return type;
            }
            catch (NoSuchSourceException e) {
                int index = current.lastIndexOf(46);
                if (index != -1) {
                    current = current.substring(0, index);
                    continue;
                }
                return null;
            }
            break;
        }
    }

    public Collection<TypeSource> buildCompilationUnit(String compilationUnitPath) throws CodeSourceException {
        if (compilationUnitPath == null) {
            throw new NullPointerException();
        }
        try {
            CompilationUnitVisitor visitor = new CompilationUnitVisitor(this);
            Visit.CU visit = visitor.visit(compilationUnitPath);
            return visit.types;
        }
        catch (Exception e) {
            if (e instanceof CodeSourceException) {
                throw (CodeSourceException)e;
            }
            throw new CodeSourceException(e);
        }
    }
}

