/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.codesource;

import java.util.LinkedHashMap;
import org.wikbook.codesource.BodySource;
import org.wikbook.codesource.FieldSource;
import org.wikbook.codesource.MemberKey;
import org.wikbook.codesource.MemberSource;
import org.wikbook.codesource.MethodSource;
import org.wikbook.codesource.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSource
extends BodySource {
    private final String name;
    private final LinkedHashMap<MemberKey, MethodSource> methods;
    private final LinkedHashMap<String, FieldSource> fields;
    private final String clip;
    private final String javaDoc;

    TypeSource(String name, LinkedHashMap<MemberKey, MethodSource> methods, LinkedHashMap<String, FieldSource> fields, String clip, String javaDoc) {
        this.name = name;
        this.methods = methods;
        this.fields = fields;
        this.clip = clip;
        this.javaDoc = javaDoc;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getJavaDoc() {
        return this.javaDoc;
    }

    @Override
    public String getClip() {
        return this.clip;
    }

    public MemberSource findMember(String member) {
        if (member == null) {
            throw new NullPointerException();
        }
        MemberKey key = MemberKey.parse(member);
        if (key.signature == null) {
            FieldSource field = this.fields.get(key.name);
            if (field != null) {
                return field;
            }
            key = new MemberKey(key.name, new Signature(new String[0]));
        }
        return this.methods.get(key);
    }

    public String toString() {
        return "TypeSource[fqn=" + this.name + "]";
    }
}

