/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.codesource;

import java.util.LinkedHashMap;
import org.wikbook.codesource.BodySource;
import org.wikbook.codesource.FieldSource;
import org.wikbook.codesource.MemberKey;
import org.wikbook.codesource.MemberSource;
import org.wikbook.codesource.MethodSource;
import org.wikbook.codesource.Signature;
import org.wikbook.text.Clip;
import org.wikbook.text.TextArea;

public class TypeSource
extends BodySource {
    final TextArea source;
    private final String name;
    private final LinkedHashMap<MemberKey, MethodSource> methods;
    private final LinkedHashMap<String, FieldSource> fields;

    TypeSource(TextArea source, String name, Clip clip, String javaDoc) {
        super(clip, javaDoc);
        this.source = source;
        this.name = name;
        this.methods = new LinkedHashMap();
        this.fields = new LinkedHashMap();
    }

    void addMethod(MethodSource method) {
        if (method.type != null) {
            throw new IllegalArgumentException();
        }
        this.methods.put(method.key, method);
        method.type = this;
    }

    void addField(FieldSource field) {
        if (field.type != null) {
            throw new IllegalArgumentException();
        }
        this.fields.put(field.name, field);
        field.type = this;
    }

    public String getName() {
        return this.name;
    }

    protected TypeSource getType() {
        return this;
    }

    public MemberSource findMember(String member) {
        if (member == null) {
            throw new NullPointerException();
        }
        MemberKey key = MemberKey.parse(member);
        if (key.signature == null) {
            FieldSource field = this.fields.get(key.name);
            if (field != null) {
                return field;
            }
            key = new MemberKey(key.name, new Signature(new String[0]));
        }
        return this.methods.get(key);
    }

    public String toString() {
        return "TypeSource[fqn=" + this.name + "]";
    }
}

