/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce4.image;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wicket.contrib.tinymce4.image.ImageFileDescription;
import wicket.contrib.tinymce4.image.ImageUploadHelper;

public class ImageUploadContentPanel
extends Panel {
    private static final long serialVersionUID = -1794953981259227822L;
    private static final Logger log = LoggerFactory.getLogger(ImageUploadContentPanel.class);
    private static final FileExtensionValidator FILE_EXTENSION_VALIDATOR = new FileExtensionValidator();
    private final String uploadFolderPath;

    public ImageUploadContentPanel(String pId, String customUploadFolderPath) {
        super(pId);
        this.setOutputMarkupId(true);
        this.uploadFolderPath = customUploadFolderPath;
        Form form = new Form("form");
        final FeedbackPanel feedback = new FeedbackPanel("feedback");
        feedback.setOutputMarkupId(true);
        form.add(new Component[]{feedback});
        final FileUploadField fileUploadField = new FileUploadField("file");
        fileUploadField.setLabel((IModel)new ResourceModel("required.label"));
        fileUploadField.setRequired(true);
        fileUploadField.add((IValidator)FILE_EXTENSION_VALIDATOR);
        form.add(new Component[]{fileUploadField});
        form.add(new Component[]{new AjaxButton("uploadButton", form){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onSubmit(AjaxRequestTarget pTarget, Form<?> pForm) {
                FileUpload fileUpload = fileUploadField.getFileUpload();
                String fileName = fileUpload.getClientFileName();
                try {
                    File currentEngineerDir = new File(ImageUploadContentPanel.this.uploadFolderPath);
                    if (!currentEngineerDir.exists()) {
                        currentEngineerDir.mkdir();
                    }
                    fileUpload.writeTo(new File(currentEngineerDir, fileName));
                }
                catch (Exception ex) {
                    log.error("Can't upload attachment: " + ex.getMessage(), (Throwable)ex);
                    ImageUploadContentPanel.this.error((Serializable)((Object)"Can't upload attachment"));
                    pTarget.add(new Component[]{feedback});
                    return;
                }
                finally {
                    fileUpload.closeStreams();
                }
                ImageFileDescription imageFileDescription = new ImageFileDescription(fileName);
                imageFileDescription.setContentType(fileUpload.getContentType());
                ImageUploadContentPanel.this.onImageUploaded(imageFileDescription, pTarget);
            }

            protected void onError(AjaxRequestTarget pTarget, Form<?> pForm) {
                pTarget.add(new Component[]{feedback});
            }
        }});
        this.add(new Component[]{form});
    }

    public ImageUploadContentPanel(String pId) {
        this(pId, ImageUploadHelper.getTemporaryDirPath());
    }

    public void onImageUploaded(ImageFileDescription pImage, AjaxRequestTarget pTarget) {
    }

    private static class FileExtensionValidator
    implements IValidator<List<FileUpload>> {
        private static final long serialVersionUID = -8116224338791429342L;
        public static final List<String> extensions = Arrays.asList("jpg", "gif", "jpeg", "png", "bmp");

        private FileExtensionValidator() {
        }

        public void validate(IValidatable<List<FileUpload>> pValidatables) {
            for (FileUpload image : (List)pValidatables.getValue()) {
                String extension = FilenameUtils.getExtension((String)image.getClientFileName());
                if (extension == null || extensions.contains(extension.toLowerCase())) continue;
                ValidationError error = new ValidationError();
                error.addKey("WrongExtensionValidator");
                error.setVariable("extensions", (Object)extensions.toString());
                pValidatables.error((IValidationError)error);
            }
        }
    }
}

