/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce4;

import java.util.Collection;
import java.util.Collections;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import wicket.contrib.tinymce4.settings.TinyMCESettings;

public class TinyMceBehavior
extends Behavior {
    private static final long serialVersionUID = 3L;
    private Component component;
    private TinyMCESettings settings;
    private boolean rendered = false;

    public TinyMceBehavior() {
        this(new TinyMCESettings());
    }

    public TinyMceBehavior(TinyMCESettings settings) {
        this.settings = settings;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (component == null) {
            throw new IllegalStateException("TinyMceBehavior is not bound to a component");
        }
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)this.getTinyMCEReference()));
        String renderOnDomReady = this.getAddTinyMceSettingsScript(TinyMCESettings.Mode.exact, Collections.singletonList(component));
        response.render(this.wrapTinyMceSettingsScript(renderOnDomReady, component));
    }

    protected HeaderItem wrapTinyMceSettingsScript(String settingScript, Component component) {
        return OnDomReadyHeaderItem.forScript((CharSequence)settingScript);
    }

    protected String getAddTinyMceSettingsScript(TinyMCESettings.Mode mode, Collection<Component> components) {
        StringBuffer script = new StringBuffer();
        if (this.rendered) {
            for (Component c : components) {
                String tryToRemoveJS = "try{tinyMCE.remove(tinyMCE.get('%s'));}catch(e){}\n";
                script.append(String.format(tryToRemoveJS, c.getMarkupId()));
            }
        }
        script.append(";tinyMCE.init({" + this.settings.toJavaScript(mode, components) + " });\n");
        this.rendered = true;
        return script.toString();
    }

    public void bind(Component component) {
        if (this.component != null) {
            throw new IllegalStateException("TinyMceBehavior can not bind to more than one component");
        }
        super.bind(component);
        if (this.isMarkupIdRequired()) {
            component.setOutputMarkupId(true);
        }
        this.component = component;
    }

    protected boolean isMarkupIdRequired() {
        return true;
    }

    protected Component getComponent() {
        return this.component;
    }

    protected ResourceReference getTinyMCEReference() {
        Application app = Application.get();
        if (RuntimeConfigurationType.DEVELOPMENT.equals((Object)app.getConfigurationType())) {
            return TinyMCESettings.TINYMCE_JS_REF;
        }
        return TinyMCESettings.TINYMCE_JS_REF_MIN;
    }
}

