/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.groups;

import org.whispersystems.libsignal.SignalProtocolAddress;

public class SenderKeyName {
    private final String groupId;
    private final SignalProtocolAddress sender;

    public SenderKeyName(String groupId, SignalProtocolAddress sender) {
        this.groupId = groupId;
        this.sender = sender;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public SignalProtocolAddress getSender() {
        return this.sender;
    }

    public String serialize() {
        return this.groupId + "::" + this.sender.getName() + "::" + String.valueOf(this.sender.getDeviceId());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SenderKeyName)) {
            return false;
        }
        SenderKeyName that = (SenderKeyName)other;
        return this.groupId.equals(that.groupId) && this.sender.equals(that.sender);
    }

    public int hashCode() {
        return this.groupId.hashCode() ^ this.sender.hashCode();
    }
}

