/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.hibernate;

import com.google.common.collect.Lists;
import com.google.inject.Module;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.plugin.hibernate.HibernateConfig;
import org.webpieces.plugin.hibernate.HibernateConfiguration;
import org.webpieces.plugin.hibernate.HibernateModule;
import org.webpieces.plugin.hibernate.HibernateRoutes;
import org.webpieces.router.api.plugins.Plugin;
import org.webpieces.router.api.routes.Routes;
import org.webpieces.util.cmdline2.Arguments;

public class HibernatePlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(HibernatePlugin.class);
    public static final String PERSISTENCE_UNIT_KEY = "hibernate.persistenceunit";
    public static final String LOAD_CLASSMETA_KEY = "hibernate.loadclassmeta";
    public static final String PERSISTENCE_TEST_UNIT = "hibernatefortest";
    private Supplier<String> persistenceUnit;
    private Supplier<Boolean> loadByClassFile;
    private HibernateConfiguration config;

    @Deprecated
    public HibernatePlugin(HibernateConfig config) {
        this.persistenceUnit = () -> config.getPersistenceUnit();
        this.loadByClassFile = () -> false;
    }

    public HibernatePlugin(Arguments cmdLineArgs) {
        log.info("classloader=" + this.getClass().getClassLoader());
        this.persistenceUnit = cmdLineArgs.createRequiredArg(PERSISTENCE_UNIT_KEY, "The named persistence unit from the list of them inside META-INF/persistence.xml", s -> s);
        this.loadByClassFile = cmdLineArgs.createOptionalArg(LOAD_CLASSMETA_KEY, "true", "If you supply a *.class for 'hibernate.persistenceunit', set this flat to true", s -> HibernatePlugin.convertBool(s));
    }

    public HibernatePlugin(HibernateConfiguration config, Arguments cmdLineArgs) {
        this.config = config;
        log.info("classloader=" + this.getClass().getClassLoader());
        this.persistenceUnit = cmdLineArgs.createRequiredArg(PERSISTENCE_UNIT_KEY, "The named persistence unit from the list of them inside META-INF/persistence.xml", s -> s);
        this.loadByClassFile = cmdLineArgs.createOptionalArg(LOAD_CLASSMETA_KEY, "true", "If you supply a *.class for 'hibernate.persistenceunit', set this flat to true", s -> HibernatePlugin.convertBool(s));
    }

    public static Boolean convertBool(String s) {
        return Boolean.valueOf(s);
    }

    public List<Module> getGuiceModules() {
        return Lists.newArrayList((Object[])new Module[]{new HibernateModule(this.persistenceUnit, this.loadByClassFile)});
    }

    public List<Routes> getRouteModules() {
        return Lists.newArrayList((Object[])new Routes[]{new HibernateRoutes(this.config)});
    }
}

