/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.hibernate;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.webpieces.ctx.api.Current;
import org.webpieces.plugin.hibernate.Em;
import org.webpieces.plugin.hibernate.TxCompleters;
import org.webpieces.plugin.hibernate.metrics.DatabaseMetric;

@Singleton
public class TransactionHelper {
    private final EntityManagerFactory factory;
    private final TxCompleters txCompleters;
    private final MeterRegistry meterRegistry;

    @Inject
    public TransactionHelper(EntityManagerFactory factory, TxCompleters txCompleters, MeterRegistry meterRegistry) {
        this.factory = factory;
        this.txCompleters = txCompleters;
        this.meterRegistry = meterRegistry;
    }

    public <Resp> Resp runWithEm(Supplier<Resp> function) {
        if (Em.get() != null) {
            throw new IllegalStateException("Cannot open another entity manager when one is already open");
        }
        EntityManager mgr = this.factory.createEntityManager();
        Em.set(mgr);
        try {
            Resp resp = function.get();
            mgr.close();
            Resp Resp = resp;
            return Resp;
        }
        catch (Throwable t) {
            this.txCompleters.closeEm(t, mgr);
            throw t;
        }
        finally {
            Em.set(null);
        }
    }

    public <T> T run(Function<EntityManager, T> function) {
        EntityManager em = Em.get();
        if (em == null) {
            em = this.factory.createEntityManager();
            Em.set(em);
        }
        try {
            T rval = function.apply(em);
            em.close();
            T t = rval;
            return t;
        }
        catch (Throwable t) {
            this.txCompleters.closeEm(t, em);
            throw t;
        }
        finally {
            Em.set(null);
        }
    }

    @Deprecated
    public <Resp> Resp runTransaction(Supplier<Resp> supplier) {
        return this.runTransaction("unknown", supplier);
    }

    public <Resp> Resp runTransaction(String transactionName, Supplier<Resp> supplier) {
        if (Em.get() == null) {
            return (Resp)this.runWithEm(() -> this.runTransactionImpl(transactionName, supplier));
        }
        return this.runTransactionImpl(transactionName, supplier);
    }

    private <Resp> Resp runTransactionImpl(String transactionName, Supplier<Resp> supplier) {
        long begin = System.currentTimeMillis();
        EntityTransaction tx = Em.get().getTransaction();
        if (tx.isActive()) {
            throw new IllegalStateException("Cannot open another transaction when one is already open");
        }
        tx.begin();
        try {
            Resp resp = supplier.get();
            tx.commit();
            Resp Resp = resp;
            return Resp;
        }
        catch (RuntimeException e) {
            this.txCompleters.rollbackTx(e, tx);
            throw e;
        }
        finally {
            this.monitorTransactionTime(transactionName, begin);
        }
    }

    private void monitorTransactionTime(String transactionName, long begin) {
        String requestPath = "unknown";
        if (Current.isContextSet() && Current.request().relativePath != null && !Current.request().relativePath.isBlank()) {
            requestPath = Current.request().relativePath;
        }
        Tags transactionTags = Tags.of((String[])new String[]{"transaction", transactionName, "request", requestPath});
        this.meterRegistry.timer(DatabaseMetric.TRANSACTION_TIME.getDottedMetricName(), (Iterable)transactionTags).record(System.currentTimeMillis() - begin, TimeUnit.MILLISECONDS);
    }
}

