/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.hibernate;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.plugin.hibernate.Em;
import org.webpieces.plugin.hibernate.NoTransaction;
import org.webpieces.plugin.hibernate.TxCompleters;
import org.webpieces.router.api.controller.actions.Action;
import org.webpieces.router.api.exceptions.HttpException;
import org.webpieces.router.api.routes.MethodMeta;
import org.webpieces.router.api.routes.RouteFilter;
import org.webpieces.util.exceptions.SneakyThrow;
import org.webpieces.util.filters.Service;

@Singleton
public class TransactionFilter
extends RouteFilter<Void> {
    private static final Logger log = LoggerFactory.getLogger(TransactionFilter.class);
    private EntityManagerFactory factory;
    private static int state = 0;
    private TxCompleters txCompleters;

    @Inject
    public TransactionFilter(EntityManagerFactory factory, TxCompleters txCompleters) {
        this.factory = factory;
        this.txCompleters = txCompleters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Action> filter(MethodMeta meta, Service<MethodMeta, Action> nextFilter) {
        NoTransaction annotation = meta.getLoadedController().getControllerMethod().getAnnotation(NoTransaction.class);
        if (annotation != null) {
            return nextFilter.invoke((Object)meta);
        }
        state = 0;
        if (Em.get() != null) {
            throw new IllegalStateException("Are you stacking two TransactionFilters as this Em should not be set yet.  be aware you do not need to call addFilter for this filter and should just include the HibernateRouteModule");
        }
        EntityManager em = this.factory.createEntityManager();
        Em.set(em);
        try {
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            log.info("Transaction beginning");
            CompletionStage completionStage = nextFilter.invoke((Object)meta).handle((action, ex) -> this.commitOrRollback(em, (Action)action, (Throwable)ex));
            return completionStage;
        }
        finally {
            Em.set(null);
        }
    }

    private Action commitOrRollback(EntityManager em, Action action, Throwable t) throws HttpException {
        EntityTransaction tx = em.getTransaction();
        if (t != null) {
            log.info("Transaction being rolled back");
            this.rollbackCloseSuppress(t, em, tx);
            if (t instanceof HttpException) {
                throw (HttpException)t;
            }
            throw SneakyThrow.sneak((Throwable)t);
        }
        log.info("Transaction being committed");
        this.commit(tx, em);
        return action;
    }

    private void commit(EntityTransaction tx, EntityManager em) {
        state = 3;
        this.txCompleters.commit(tx, em);
    }

    private void rollbackCloseSuppress(Throwable t, EntityManager mgr, EntityTransaction tx) {
        state = 2;
        this.txCompleters.rollbackCloseSuppress(t, mgr, tx);
    }

    public void initialize(Void initialConfig) {
    }

    public static int getState() {
        return state;
    }
}

