/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.hibernate;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.spi.PersistenceUnitInfo;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.plugin.hibernate.HibernateLookup;
import org.webpieces.plugin.hibernate.PersistenceUnitInfoProxy;
import org.webpieces.router.api.extensions.EntityLookup;

public class HibernateModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(HibernateModule.class);
    private Supplier<String> persistenceUnit;
    private ClassLoader entityClassLoader;
    private Supplier<Boolean> loadByClassFile;

    public HibernateModule(Supplier<String> persistenceUnit2, Supplier<Boolean> loadByClassFile) {
        this.loadByClassFile = loadByClassFile;
        this.entityClassLoader = Thread.currentThread().getContextClassLoader();
        this.persistenceUnit = persistenceUnit2;
    }

    protected void configure() {
        Multibinder uriBinder = Multibinder.newSetBinder((Binder)this.binder(), EntityLookup.class);
        uriBinder.addBinding().to(HibernateLookup.class);
    }

    @Singleton
    @Provides
    public EntityManagerFactory providesSessionFactory(MeterRegistry metrics, Injector injector) throws IOException {
        boolean loadByClassMeta = this.loadByClassFile.get();
        String pu = this.persistenceUnit.get();
        EntityManagerFactory factory = loadByClassMeta ? this.loadByClassMeta(pu, metrics, injector) : this.createEntityMgrFromPuFile(pu);
        return factory;
    }

    private EntityManagerFactory createEntityMgrFromPuFile(String pu) {
        log.info("Loading Hibernate from xml file.  ENTITY classloader=" + this.entityClassLoader + " hibernate classloader=" + ((Object)((Object)this)).getClass().getClassLoader() + " pu=" + pu);
        Map<String, Object> properties = this.createClassLoaderProperty();
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)pu, properties);
        log.info("Done loading Hibernate");
        return factory;
    }

    private EntityManagerFactory loadByClassMeta(String clazz, MeterRegistry metrics, Injector injector) {
        log.info("Loading Hibernate from class meta.  ENTITY classloader=" + this.entityClassLoader + " hibernate classloader=" + ((Object)((Object)this)).getClass().getClassLoader() + " class=" + clazz);
        Class<?> loadClass = null;
        try {
            loadClass = this.entityClassLoader.loadClass(clazz);
            Object newInstance = injector.getInstance(loadClass);
            if (!(newInstance instanceof PersistenceUnitInfo)) {
                throw new IllegalArgumentException(clazz + " is not an instanceof PersistenceUnitInfo and must be");
            }
            PersistenceUnitInfo info = (PersistenceUnitInfo)newInstance;
            PersistenceUnitInfoProxy proxy = new PersistenceUnitInfoProxy(info, this.entityClassLoader);
            Map<String, Object> overrideProperties = this.createClassLoaderProperty();
            return new HibernatePersistenceProvider().createContainerEntityManagerFactory((PersistenceUnitInfo)proxy, overrideProperties);
        }
        catch (ClassNotFoundException | SecurityException e) {
            throw new IllegalStateException("Could not construct DB settings", e);
        }
    }

    private Map<String, Object> createClassLoaderProperty() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(this.entityClassLoader);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("hibernate.classLoaders", classLoaders);
        return properties;
    }
}

