/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.hibernate;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.webpieces.plugin.hibernate.Em;
import org.webpieces.plugin.hibernate.TxCompleters;

public class TransactionHelper {
    private EntityManagerFactory factory;
    private TxCompleters txCompleters;

    @Inject
    public TransactionHelper(EntityManagerFactory factory, TxCompleters txCompleters) {
        this.factory = factory;
        this.txCompleters = txCompleters;
    }

    public <Resp> Resp runWithEm(Function<EntityManager, Resp> function) {
        EntityManager mgr = this.factory.createEntityManager();
        Em.set(mgr);
        try {
            Resp resp = function.apply(mgr);
            mgr.close();
            Resp Resp = resp;
            return Resp;
        }
        catch (RuntimeException e) {
            this.tryClose(mgr, e);
            throw e;
        }
        finally {
            Em.set(null);
        }
    }

    public <Resp> Resp runWithEm(Supplier<Resp> function) {
        EntityManager mgr = this.factory.createEntityManager();
        Em.set(mgr);
        try {
            Resp resp = function.get();
            mgr.close();
            Resp Resp = resp;
            return Resp;
        }
        catch (RuntimeException e) {
            this.tryClose(mgr, e);
            throw e;
        }
        finally {
            Em.set(null);
        }
    }

    public <Resp> Resp runTransaction(EntityManager mgr, Supplier<Resp> function) {
        EntityTransaction tx = mgr.getTransaction();
        if (tx.isActive()) {
            throw new IllegalStateException("You cannot call runTransaction in a transaction.  Call this method inside the function you pass to runWithEm.");
        }
        tx.begin();
        try {
            Resp resp = function.get();
            tx.commit();
            return resp;
        }
        catch (RuntimeException e) {
            this.txCompleters.rollbackTx(e, tx);
            throw e;
        }
    }

    private void tryClose(EntityManager mgr, RuntimeException e) {
        try {
            mgr.close();
        }
        catch (RuntimeException nextExc) {
            e.addSuppressed(nextExc);
        }
    }

    public <Resp> Resp runTransaction(Function<EntityManager, Resp> function) {
        EntityManager mgr = this.factory.createEntityManager();
        if (mgr.getTransaction().isActive()) {
            throw new IllegalStateException("You cannot call runTransaction in a transaction");
        }
        EntityTransaction tx = mgr.getTransaction();
        tx.begin();
        Em.set(mgr);
        try {
            Resp resp = function.apply(mgr);
            this.txCompleters.commit(tx, mgr);
            Resp Resp = resp;
            return Resp;
        }
        catch (RuntimeException e) {
            this.txCompleters.rollbackCloseSuppress(e, mgr, tx);
            throw e;
        }
        finally {
            Em.set(null);
        }
    }

    public <Resp> Resp runTransaction(Supplier<Resp> function) {
        EntityManager mgr = this.factory.createEntityManager();
        if (mgr.getTransaction().isActive()) {
            throw new IllegalStateException("You cannot call runTransaction in a transaction");
        }
        EntityTransaction tx = mgr.getTransaction();
        tx.begin();
        Em.set(mgr);
        try {
            Resp resp = function.get();
            this.txCompleters.commit(tx, mgr);
            Resp Resp = resp;
            return Resp;
        }
        catch (RuntimeException e) {
            this.txCompleters.rollbackCloseSuppress(e, mgr, tx);
            throw e;
        }
        finally {
            Em.set(null);
        }
    }
}

