/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugin.hibernate;

import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.plugin.hibernate.Em;
import org.webpieces.plugin.hibernate.UseQuery;
import org.webpieces.router.api.extensions.EntityLookup;
import org.webpieces.router.api.extensions.Meta;
import org.webpieces.router.api.extensions.ObjectStringConverter;
import org.webpieces.router.api.extensions.ParamMeta;
import org.webpieces.router.impl.params.ObjectTranslator;
import org.webpieces.router.impl.params.ParamNode;
import org.webpieces.router.impl.params.ParamTreeNode;
import org.webpieces.router.impl.params.ValueNode;

public class HibernateLookup
implements EntityLookup {
    private static final Logger log = LoggerFactory.getLogger(HibernateLookup.class);
    private EntityManagerFactory factory;
    private ObjectTranslator translator;

    @Inject
    public HibernateLookup(EntityManagerFactory factory, ObjectTranslator translator) {
        this.factory = factory;
        this.translator = translator;
    }

    public <T> boolean isManaged(Class<T> paramTypeToCreate) {
        EntityManager entityManager = Em.get();
        if (entityManager == null) {
            return this.isManagedOutsideTransaction(paramTypeToCreate);
        }
        return this.isManagedImpl(paramTypeToCreate, entityManager);
    }

    private <T> boolean isManagedImpl(Class<T> paramTypeToCreate, EntityManager entityManager) {
        try {
            ManagedType managedType = entityManager.getMetamodel().managedType(paramTypeToCreate);
            IdentifiableType entityType = (IdentifiableType)managedType;
            if (!entityType.hasSingleIdAttribute()) {
                log.warn("You generally should be using beans with hibernate ids since this is a hibernate class");
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> boolean isManagedOutsideTransaction(Class<T> paramTypeToCreate) {
        try (EntityManager entityManager = this.factory.createEntityManager();){
            boolean bl = this.isManagedImpl(paramTypeToCreate, entityManager);
            return bl;
        }
    }

    public <T> CompletableFuture<T> find(Meta paramMeta, ParamTreeNode tree, Function<Class<T>, T> beanCreate) {
        Object result = this.findImpl(paramMeta, tree, beanCreate);
        return CompletableFuture.completedFuture(result);
    }

    public <T> Object findImpl(Meta paramMeta, ParamTreeNode tree, Function<Class<T>, T> beanCreate) {
        if (!(paramMeta instanceof ParamMeta)) {
            throw new UnsupportedOperationException("this plugin does not support type=" + paramMeta.getClass());
        }
        EntityManager entityManager = Em.get();
        if (entityManager == null) {
            return this.findEntityOutsideTransaction((Meta)((ParamMeta)paramMeta), tree, beanCreate);
        }
        return this.findEntityImpl((ParamMeta)paramMeta, tree, beanCreate, entityManager);
    }

    private <T> T findEntityImpl(ParamMeta paramMeta, ParamTreeNode tree, Function<Class<T>, T> beanCreate, EntityManager entityManager) {
        ParamMeta m = paramMeta;
        Class paramTypeToCreate = m.getFieldClass();
        Metamodel metamodel = entityManager.getMetamodel();
        ManagedType managedType = metamodel.managedType(paramTypeToCreate);
        IdentifiableType entityType = (IdentifiableType)managedType;
        Class idClazz = entityType.getIdType().getJavaType();
        SingularAttribute idAttribute = entityType.getId(idClazz);
        String name = idAttribute.getName();
        ParamNode paramNode = tree.get(name);
        String value = null;
        if (paramNode != null) {
            if (!(paramNode instanceof ValueNode)) {
                throw new IllegalStateException("The id field in the hibernate entity should have matched to a ValueNode on incoming data and did not. node=" + paramNode + ".  bad multipart form?  (Please let us know so we can pair with you on this and I can add better error messaging)");
            }
            ValueNode node = (ValueNode)paramNode;
            value = node.getValue();
        }
        if (value == null) {
            return beanCreate.apply(paramTypeToCreate);
        }
        ObjectStringConverter unmarshaller = this.translator.getConverter(idClazz);
        Object id = unmarshaller.stringToObject(value);
        UseQuery namedQuery = this.fetchUseQuery(m.getAnnotations());
        if (namedQuery == null) {
            return (T)entityManager.find(paramTypeToCreate, id);
        }
        Query query = entityManager.createNamedQuery(namedQuery.value());
        query.setParameter(namedQuery.id(), id);
        return (T)query.getSingleResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T findEntityOutsideTransaction(Meta paramMeta, ParamTreeNode tree, Function<Class<T>, T> beanCreate) {
        try (EntityManager entityManager = this.factory.createEntityManager();){
            T t = this.findEntityImpl((ParamMeta)paramMeta, tree, beanCreate, entityManager);
            return t;
        }
    }

    private UseQuery fetchUseQuery(Annotation[] annotations) {
        for (Annotation anno : annotations) {
            if (!(anno instanceof UseQuery)) continue;
            return (UseQuery)anno;
        }
        return null;
    }
}

