/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.hibernate;

import com.google.common.collect.Lists;
import com.google.inject.Module;
import java.util.List;
import java.util.function.Supplier;
import org.webpieces.plugins.hibernate.HibernateConfig;
import org.webpieces.plugins.hibernate.HibernateModule;
import org.webpieces.plugins.hibernate.HibernateRoutes;
import org.webpieces.router.api.plugins.Plugin;
import org.webpieces.router.api.routes.Routes;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class HibernatePlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(HibernatePlugin.class);
    public static final String PERSISTENCE_UNIT_KEY = "hibernate.persistenceunit";
    public static final String PERSISTENCE_TEST_UNIT = "hibernatefortest";
    private Supplier<String> persistenceUnit;

    public HibernatePlugin(HibernateConfig config) {
        log.info("classloader=" + this.getClass().getClassLoader());
        this.persistenceUnit = config.getCmdLineArguments().consumeRequired(PERSISTENCE_UNIT_KEY, "The named persistence unit from the list of them inside META-INF/persistence.xml", s -> s);
    }

    public List<Module> getGuiceModules() {
        return Lists.newArrayList((Object[])new Module[]{new HibernateModule(this.persistenceUnit)});
    }

    public List<Routes> getRouteModules() {
        return Lists.newArrayList((Object[])new Routes[]{new HibernateRoutes()});
    }
}

