/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.hibernate;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.webpieces.plugins.hibernate.HibernateLookup;
import org.webpieces.router.api.extensions.EntityLookup;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class HibernateModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(HibernateModule.class);
    private Supplier<String> persistenceUnit;
    private ClassLoader entityClassLoader = Thread.currentThread().getContextClassLoader();

    public HibernateModule(Supplier<String> persistenceUnit2) {
        this.persistenceUnit = persistenceUnit2;
    }

    protected void configure() {
        Multibinder uriBinder = Multibinder.newSetBinder((Binder)this.binder(), EntityLookup.class);
        uriBinder.addBinding().to(HibernateLookup.class);
    }

    @Singleton
    @Provides
    public EntityManagerFactory providesSessionFactory() throws IOException {
        String pu = this.persistenceUnit.get();
        log.info("Loading Hibernate.  ENTITY classloader=" + this.entityClassLoader + " hibernate classloader=" + ((Object)((Object)this)).getClass().getClassLoader() + " pu=" + pu);
        Map<String, Object> properties = this.createClassLoaderProperty();
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)pu, properties);
        log.info("Done loading Hibernate");
        return factory;
    }

    private Map<String, Object> createClassLoaderProperty() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(this.entityClassLoader);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("hibernate.classLoaders", classLoaders);
        return properties;
    }
}

