/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.hibernate;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.webpieces.plugins.hibernate.Em;
import org.webpieces.router.api.actions.Action;
import org.webpieces.router.api.dto.MethodMeta;
import org.webpieces.router.api.exceptions.HttpException;
import org.webpieces.router.api.routing.RouteFilter;
import org.webpieces.util.filters.Service;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

@Singleton
public class TransactionFilter
extends RouteFilter<Void> {
    private static final Logger log = LoggerFactory.getLogger(TransactionFilter.class);
    private EntityManagerFactory factory;
    private static int state = 0;

    @Inject
    public TransactionFilter(EntityManagerFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Action> filter(MethodMeta meta, Service<MethodMeta, Action> nextFilter) {
        state = 0;
        if (Em.get() != null) {
            throw new IllegalStateException("Are you stacking two TransactionFilters as this Em should not be set yet.  be aware you do not need to call addFilter for this filter and should just include the HibernateRouteModule");
        }
        EntityManager em = this.factory.createEntityManager();
        Em.set(em);
        try {
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            log.info("Transaction beginning");
            CompletionStage completionStage = nextFilter.invoke((Object)meta).handle((action, ex) -> this.commitOrRollback(em, (Action)action, (Throwable)ex));
            return completionStage;
        }
        finally {
            Em.set(null);
        }
    }

    private Action commitOrRollback(EntityManager em, Action action, Throwable t) throws HttpException {
        EntityTransaction tx = em.getTransaction();
        if (t != null) {
            log.info("Transaction being rolled back");
            this.rollbackTx(t, tx);
            this.closeEm(t, em);
            if (t instanceof HttpException) {
                throw (HttpException)t;
            }
            throw new RuntimeException(t);
        }
        log.info("Transaction being committed");
        this.commit(tx, em);
        return action;
    }

    private void commit(EntityTransaction tx, EntityManager em) {
        try {
            state = 3;
            tx.commit();
            em.close();
        }
        catch (Throwable e) {
            this.closeEm(e, em);
            throw new RuntimeException(e);
        }
    }

    private void closeEm(Throwable t, EntityManager em) {
        try {
            em.close();
        }
        catch (Throwable e) {
            t.addSuppressed(e);
        }
    }

    private void rollbackTx(Throwable t, EntityTransaction tx) {
        try {
            state = 2;
            tx.rollback();
        }
        catch (Throwable e) {
            t.addSuppressed(e);
        }
    }

    public void initialize(Void initialConfig) {
    }

    public static int getState() {
        return state;
    }
}

