/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.httpproxy.impl.chain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.frontend.api.FrontendSocket;
import org.webpieces.frontend.api.HttpRequestListener;
import org.webpieces.frontend.api.exception.HttpException;
import org.webpieces.httpclient.api.CloseListener;
import org.webpieces.httpclient.api.HttpClient;
import org.webpieces.httpclient.api.HttpSocket;
import org.webpieces.httpclient.api.ResponseListener;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.HttpUri;
import org.webpieces.httpparser.api.dto.UrlInfo;
import org.webpieces.httpproxy.api.ProxyConfig;
import org.webpieces.httpproxy.impl.chain.LayerZSendBadResponse;
import org.webpieces.httpproxy.impl.responsechain.Layer1Response;
import org.webpieces.httpproxy.impl.responsechain.Layer2ResponseListener;

public class Layer4Processor
implements HttpRequestListener {
    private static final Logger log = LoggerFactory.getLogger(Layer4Processor.class);
    @Inject
    private ProxyConfig config;
    @Inject
    private HttpClient httpClient;
    @Inject
    private Layer2ResponseListener layer2Processor;
    @Inject
    private LayerZSendBadResponse badResponse;
    private final Cache<SocketAddress, HttpSocket> cache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(10000L).expireAfterAccess(3L, TimeUnit.MINUTES).removalListener((RemovalListener)new SocketExpiredListener()).build();

    public void processHttpRequests(FrontendSocket channel, HttpRequest req, boolean isHttps) {
        HttpSocket socket;
        HttpUri uri;
        UrlInfo info;
        log.info("incoming request. channel=" + channel + "=\n" + req);
        InetSocketAddress addr = req.getServerToConnectTo(null);
        if (this.config.isForceAllConnectionToHttps()) {
            addr = new InetSocketAddress(addr.getHostName(), 443);
        }
        if ((info = (uri = req.getRequestLine().getUri()).getUriBreakdown()).getPrefix() != null) {
            uri.setUri(info.getFullPath());
        }
        if ((socket = (HttpSocket)this.cache.getIfPresent((Object)addr)) != null) {
            this.sendData(channel, socket, req);
        } else {
            this.openAndConnectSocket(addr, req, channel);
        }
    }

    private void sendData(FrontendSocket channel, HttpSocket socket, HttpRequest req) {
        socket.send(req, (ResponseListener)new Layer1Response(this.layer2Processor, channel, req));
    }

    private HttpSocket openAndConnectSocket(InetSocketAddress addr, HttpRequest req, FrontendSocket channel) {
        HttpSocket socket = this.httpClient.openHttpSocket("" + addr.getHostName() + "-" + addr.getPort(), (CloseListener)new Layer1CloseListener(addr));
        log.info("connecting to addr=" + addr);
        ((CompletableFuture)socket.connect(addr).thenAccept(s -> {
            this.sendData(channel, socket, req);
            this.cache.put((Object)addr, (Object)socket);
        })).exceptionally(e -> this.layer2Processor.processError(channel, req, (Throwable)e));
        return socket;
    }

    public void clientOpenChannel(FrontendSocket channel) {
        log.info("browser client open channel=" + channel);
    }

    public void clientClosedChannel(FrontendSocket channel) {
        log.info("browser client closed channel=" + channel);
    }

    public void sendServerResponse(FrontendSocket channel, HttpException exc) {
        this.badResponse.sendServerResponse(channel, exc);
    }

    public void applyWriteBackPressure(FrontendSocket channel) {
        log.error("NEED APPLY BACKPRESSURE", (Throwable)new RuntimeException());
    }

    public void releaseBackPressure(FrontendSocket channel) {
    }

    private class Layer1CloseListener
    implements CloseListener {
        private SocketAddress addr;

        public Layer1CloseListener(SocketAddress addr) {
            this.addr = addr;
        }

        public void farEndClosed(HttpSocket socket) {
            log.info("socket addr=" + this.addr + " closed, invalidating cache");
            Layer4Processor.this.cache.invalidate((Object)this.addr);
        }
    }

    private class SocketExpiredListener
    implements RemovalListener<SocketAddress, HttpSocket> {
        private SocketExpiredListener() {
        }

        public void onRemoval(RemovalNotification<SocketAddress, HttpSocket> notification) {
            log.info("closing socket=" + notification.getKey() + ".  cache removal cause=" + notification.getCause());
            HttpSocket socket = (HttpSocket)notification.getValue();
            socket.closeSocket();
        }
    }
}

