/*
 * Decompiled with CFR 0.152.
 */
package webpiecesxxxxxpackage.services;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.util.file.VirtualFile;
import org.webpieces.webserver.api.IDESupport;
import org.webpieces.webserver.api.WebpiecesServer;
import webpiecesxxxxxpackage.services.DevConfig;

public abstract class YourCompanyAbstractDevServer {
    private static final Logger log = LoggerFactory.getLogger(YourCompanyAbstractDevServer.class);
    protected VirtualFile directory;
    protected ArrayList<VirtualFile> srcPaths;
    protected String[] args;
    private ExecutorService fileWatchThread = Executors.newFixedThreadPool(1, new MyFileWatchThreadFactory());

    public YourCompanyAbstractDevServer(String name, boolean usePortZero) {
        String[] args;
        String file = "/" + WebpiecesServer.class.getName().replaceAll("\\.", "/") + ".class";
        URL res = this.getClass().getResource(file);
        if (res.getProtocol().equals("jar")) {
            this.watchForDangerousJarChanges(res);
        }
        DevConfig config = this.getConfig();
        this.directory = IDESupport.modifyForIDE((String)name);
        this.srcPaths = new ArrayList();
        this.srcPaths.add(this.directory.child(name + "/src/main/java"));
        this.srcPaths.add(this.directory.child(name + "-dev/src/main/java"));
        ArrayList<Object> tempArgs = new ArrayList<Object>();
        if (usePortZero) {
            tempArgs.add("-http.port=:0");
            tempArgs.add("-https.port=:0");
        } else {
            tempArgs.add("-http.port=:" + config.getHttpPort());
            tempArgs.add("-https.port=:" + config.getHttpsPort());
        }
        tempArgs.add("-https.over.http=true");
        if (config.getHibernateSettingsClazz() != null) {
            tempArgs.add("-hibernate.persistenceunit=" + config.getHibernateSettingsClazz());
        }
        if ((args = config.getExtraArguments()) != null) {
            for (String a : args) {
                tempArgs.add(a);
            }
        }
        this.args = tempArgs.toArray(new String[0]);
    }

    protected abstract DevConfig getConfig();

    public abstract void start();

    private void watchForDangerousJarChanges(URL res) {
        try {
            this.watchForDangerousJarChangesImpl(res);
        }
        catch (IOException e) {
            throw new RuntimeException("Weird but this code can be safely removed BUT just make sure you restart your servers when upgrading any 3rd party jars");
        }
    }

    private void watchForDangerousJarChangesImpl(URL res) throws IOException {
        log.info("res=" + res.getFile() + " res=" + res + " res1" + res.getPath());
        String filePath = res.getFile();
        String absPath = filePath.substring("file:".length());
        String fullJarPath = absPath.split("!")[0];
        File f = new File(fullJarPath);
        Path directoryPath = f.getParentFile().toPath();
        WatchService watcher = FileSystems.getDefault().newWatchService();
        directoryPath.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.fileWatchThread.execute(new MyFileWatchRunnable(watcher));
    }

    private class MyFileWatchThreadFactory
    implements ThreadFactory {
        private MyFileWatchThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("fileWatchThread");
            return t;
        }
    }

    private class MyFileWatchRunnable
    implements Runnable {
        private WatchService watcher;

        public MyFileWatchRunnable(WatchService watcher) {
            this.watcher = watcher;
        }

        @Override
        public void run() {
            try {
                log.info("Starting to watch files");
                WatchKey key = this.watcher.take();
            }
            catch (Throwable ex) {
                log.error("Exception", ex);
            }
            log.error("\n-------------------------------------------------------------------------------\nWebpiecees was upgraded so we need to shutdown the server to use the new jar files or bad things happen\n-------------------------------------------------------------------------------");
            System.exit(9492);
        }
    }
}

