'use strict';

var DEFAULT_SCALE = 1.5;

// Parse query string to extract some parameters (it can fail for some input)
var query = document.location.href.replace(/^[^?]*(\?([^#]*))?(#.*)?/, '$2');
var queryParams = query ? JSON.parse('{' + query.split('&').map(function (a) {
  return a.split('=').map(decodeURIComponent).map(JSON.stringify).join(': ');
}).join(',') + '}') : {};

var url = queryParams.file || '../../web/compressed.tracemonkey-pldi-09.pdf';

function renderDocument(pdf, svgLib) {
  var promise = Promise.resolve();
  for (var i = 1; i <= pdf.numPages; i++) {
    // Using promise to fetch and render the next page
    promise = promise.then(function (pageNum) {
      return pdf.getPage(pageNum).then(function (page) {
        var viewport = page.getViewport(DEFAULT_SCALE);

        var container = document.createElement('div');
        container.id = 'pageContainer' + pageNum;
        container.className = 'pageContainer';
        container.style.width = viewport.width + 'px';
        container.style.height = viewport.height + 'px';
        document.body.appendChild(container);

        return page.getOperatorList().then(function (opList) {
          var svgGfx = new svgLib.SVGGraphics(page.commonObjs, page.objs);
          return svgGfx.getSVG(opList, viewport).then(function (svg) {
            container.appendChild(svg);
          });
        });
      });
    }.bind(null, i));
  }
}

Promise.all([System.import('pdfjs/display/api'),
             System.import('pdfjs/display/svg'),
             System.import('pdfjs/display/worker_options'),
             System.import('pdfjs/display/network'),
             System.resolve('pdfjs/worker_loader')])
       .then(function (modules) {
  var api = modules[0];
  var svg = modules[1];
  var GlobalWorkerOptions = modules[2].GlobalWorkerOptions;
  var network = modules[3];
  api.setPDFNetworkStreamFactory((params) => {
    return new network.PDFNetworkStream(params);
  });

  // In production, change this to point to the built `pdf.worker.js` file.
  GlobalWorkerOptions.workerSrc = modules[4];

  // In production, change this to point to where the cMaps are placed.
  var CMAP_URL = '../../external/bcmaps/';
  var CMAP_PACKED = true;

  // Fetch the PDF document from the URL using promises.
  api.getDocument({
    url: url,
    cMapUrl: CMAP_URL,
    cMapPacked: CMAP_PACKED,
  }).then(function(doc) {
    renderDocument(doc, svg);
  });
});
