import Cartesian2 from "../../Core/Cartesian2.js";
import ShaderDestination from "../../Renderer/ShaderDestination.js";
import VerticalExaggerationStageVS from "../../Shaders/Model/VerticalExaggerationStageVS.js";

/**
 * The custom shader pipeline stage takes GLSL callbacks from the
 * {@link CustomShader} and inserts them into the overall shader code for the
 * {@link Model}. The input to the callback is a struct with many
 * properties that depend on the attributes of the primitive. This shader code
 * is automatically generated by this stage.
 *
 * @namespace VerticalExaggerationPipelineStage
 *
 * @private
 */
const VerticalExaggerationPipelineStage = {
  name: "VerticalExaggerationPipelineStage", // Helps with debugging
};

const scratchExaggerationUniform = new Cartesian2();

/**
 * Add vertical exaggeration to a shader
 *
 * @param {PrimitiveRenderResources} renderResources The render resources for the primitive
 * @param {ModelComponents.Primitive} primitive The primitive to be rendered
 * @param {FrameState} frameState The frame state.
 * @private
 */
VerticalExaggerationPipelineStage.process = function (
  renderResources,
  primitive,
  frameState
) {
  const { shaderBuilder, uniformMap } = renderResources;

  shaderBuilder.addVertexLines(VerticalExaggerationStageVS);

  shaderBuilder.addDefine(
    "HAS_VERTICAL_EXAGGERATION",
    undefined,
    ShaderDestination.VERTEX
  );

  shaderBuilder.addUniform(
    "vec2",
    "u_verticalExaggerationAndRelativeHeight",
    ShaderDestination.VERTEX
  );

  uniformMap.u_verticalExaggerationAndRelativeHeight = function () {
    return Cartesian2.fromElements(
      frameState.verticalExaggeration,
      frameState.verticalExaggerationRelativeHeight,
      scratchExaggerationUniform
    );
  };
};

export default VerticalExaggerationPipelineStage;
