steal('jquery/event').then(function( $ ) {
	$.event.reverse = function(name, attributes) {
		var bound = $(),
			count = 0;

		$.event.special[name] = {
			setup: function() {
				// add and sort the resizers array
				// don't add window because it can't be compared easily
				if ( this !== window ) {
					bound.push(this);
					$.unique(bound);
				}
				// returns false if the window
				return this !== window;
			},
			teardown: function() {
				// we shouldn't have to sort
				bound = bound.not(this);
				// returns false if the window
				return this !== window;
			},
			add: function( handleObj ) {
				var origHandler = handleObj.handler;
				handleObj.origHandler = origHandler;

				handleObj.handler = function( ev, data ) {
					var isWindow = this === window;
					if(attributes && attributes.handler) {
						var result = attributes.handler.apply(this, arguments);
						if(result === true) {
							return;
						}
					}

					// if this is the first handler for this event ...
					if ( count === 0 ) {
						// prevent others from doing what we are about to do
						count++;
						var where = data === false ? ev.target : this

						// trigger all this element's handlers
						$.event.handle.call(where, ev);
						if ( ev.isPropagationStopped() ) {
							count--;
							return;
						}

						// get all other elements within this element that listen to move
						// and trigger their resize events
						var index = bound.index(this),
							length = bound.length,
							child, sub;

						// if index == -1 it's the window
						while (++index < length && (child = bound[index]) && (isWindow || $.contains(where, child)) ) {

							// call the event
							$.event.handle.call(child, ev);

							if ( ev.isPropagationStopped() ) {
								// move index until the item is not in the current child
								while (++index < length && (sub = bound[index]) ) {
									if (!$.contains(child, sub) ) {
										// set index back one
										index--;
										break
									}
								}
							}
						}

						// prevent others from responding
						ev.stopImmediatePropagation();
						count--;
					} else {
						handleObj.origHandler.call(this, ev, data);
					}
				}
			}
		};

		// automatically bind on these
		$([document, window]).bind(name, function() {});

		return $.event.special[name];
	}
})