/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.web3j.codegen.Console;
import org.web3j.codegen.FunctionWrapperGenerator;
import org.web3j.codegen.SolidityFunctionWrapper;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.methods.response.AbiDefinition;
import org.web3j.tx.Contract;
import org.web3j.utils.Collection;
import org.web3j.utils.Files;
import org.web3j.utils.Strings;
import picocli.CommandLine;

public class SolidityFunctionWrapperGenerator
extends FunctionWrapperGenerator {
    public static final String COMMAND_SOLIDITY = "solidity";
    public static final String COMMAND_GENERATE = "generate";
    public static final String COMMAND_PREFIX = "solidity generate";
    private final File binFile;
    private final File abiFile;
    private final String contractName;
    private final int addressLength;
    private final boolean generateSendTxForCalls;

    protected SolidityFunctionWrapperGenerator(File binFile, File abiFile, File destinationDir, String contractName, String basePackageName, boolean useJavaNativeTypes, boolean useJavaPrimitiveTypes, int addressLength) {
        this(binFile, abiFile, destinationDir, contractName, basePackageName, useJavaNativeTypes, useJavaPrimitiveTypes, false, Contract.class, addressLength);
    }

    protected SolidityFunctionWrapperGenerator(File binFile, File abiFile, File destinationDir, String contractName, String basePackageName, boolean useJavaNativeTypes, boolean useJavaPrimitiveTypes, boolean generateSendTxForCalls, Class<? extends Contract> contractClass, int addressLength) {
        super(contractClass, destinationDir, basePackageName, useJavaNativeTypes, useJavaPrimitiveTypes);
        this.binFile = binFile;
        this.abiFile = abiFile;
        this.contractName = contractName;
        this.addressLength = addressLength;
        this.generateSendTxForCalls = generateSendTxForCalls;
    }

    protected List<AbiDefinition> loadContractDefinition(File absFile) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        AbiDefinition[] abiDefinition = (AbiDefinition[])objectMapper.readValue(absFile, AbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    @Override
    public final void generate() throws IOException, ClassNotFoundException {
        List<AbiDefinition> functionDefinitions;
        String binary = "Bin file was not provided";
        if (this.binFile != null) {
            byte[] bytes = Files.readBytes((File)this.binFile);
            binary = new String(bytes);
        }
        if ((functionDefinitions = this.loadContractDefinition(this.abiFile)).isEmpty()) {
            Console.exitError("Unable to parse input ABI file");
        } else {
            String className = Strings.capitaliseFirstLetter((String)this.contractName);
            System.out.print("Generating " + this.basePackageName + "." + className + " ... ");
            new SolidityFunctionWrapper(this.useJavaNativeTypes, this.useJavaPrimitiveTypes, this.generateSendTxForCalls, this.addressLength).generateJavaFiles(this.contractClass, this.contractName, binary, functionDefinitions, this.destinationDirLocation.toString(), this.basePackageName, null);
            System.out.println("File written to " + this.destinationDirLocation.toString() + "\n");
        }
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals(COMMAND_SOLIDITY)) {
            args = Collection.tail((String[])args);
        }
        if (args.length > 0 && args[0].equals(COMMAND_GENERATE)) {
            args = Collection.tail((String[])args);
        }
        CommandLine.run((Runnable)new PicocliRunner(), (String[])args);
    }

    @CommandLine.Command(name="solidity generate", mixinStandardHelpOptions=true, version={"4.0"}, sortOptions=false)
    private static class PicocliRunner
    implements Runnable {
        @CommandLine.Option(names={"-a", "--abiFile"}, description={"abi file with contract definition."}, required=true)
        private File abiFile;
        @CommandLine.Option(names={"-b", "--binFile"}, description={"bin file with contract compiled code in order to generate deploy methods."}, required=false)
        private File binFile;
        @CommandLine.Option(names={"-c", "--contractName"}, description={"contract name (defaults to ABI file name)."}, required=false)
        private String contractName;
        @CommandLine.Option(names={"-o", "--outputDir"}, description={"destination base directory."}, required=true)
        private File destinationFileDir;
        @CommandLine.Option(names={"-p", "--package"}, description={"base package name."}, required=true)
        private String packageName;
        @CommandLine.Option(names={"-al", "--addressLength"}, description={"address length in bytes (defaults to 20)."}, required=false)
        private int addressLength = 20;
        @CommandLine.Option(names={"-jt", "--javaTypes"}, description={"use native Java types."}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
        private boolean javaTypes = true;
        @CommandLine.Option(names={"-st", "--solidityTypes"}, description={"use solidity types."}, required=false)
        private boolean solidityTypes;
        @CommandLine.Option(names={"-pt", "--primitiveTypes"}, description={"use Java primitive types."}, required=false)
        private boolean primitiveTypes = false;

        private PicocliRunner() {
        }

        @Override
        public void run() {
            try {
                boolean useJavaTypes;
                boolean bl = useJavaTypes = !this.solidityTypes;
                if (this.contractName == null || this.contractName.isEmpty()) {
                    this.contractName = FunctionWrapperGenerator.getFileNameNoExtension(this.abiFile.getName());
                }
                new SolidityFunctionWrapperGenerator(this.binFile, this.abiFile, this.destinationFileDir, this.contractName, this.packageName, useJavaTypes, this.primitiveTypes, this.addressLength).generate();
            }
            catch (Exception e) {
                Console.exitError(e);
            }
        }
    }
}

