/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen.java;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.web3j.codegen.unit.gen.Parser;
import org.web3j.codegen.unit.gen.utils.MappingHelper;
import org.web3j.codegen.unit.gen.utils.NameUtils;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class JavaParser
extends Parser {
    public JavaParser(Class<?> theContract, Method method, MappingHelper mappingHelper) {
        super(theContract, method, mappingHelper);
    }

    public String generateAssertionJavaPoetStringTypes() {
        Type returnType = this.getMethodReturnType();
        Object[] body = this.generatePlaceholderValues();
        StringBuilder symbolBuilder = new StringBuilder();
        symbolBuilder.append("$T.");
        if (returnType.equals(TransactionReceipt.class)) {
            symbolBuilder.append("assertTrue($L.isStatusOK())");
        } else {
            symbolBuilder.append("assertEquals(");
            if (returnType.getTypeName().contains("Tuple")) {
                symbolBuilder.append("new $T(");
                for (Type t : this.getTypeArray(returnType)) {
                    symbolBuilder.append(this.mappingHelper.getPoetFormat().get(t)).append(", ");
                }
                symbolBuilder.deleteCharAt(symbolBuilder.lastIndexOf(", "));
                symbolBuilder.append(")");
            } else {
                symbolBuilder.append(this.mappingHelper.getPoetFormat().get(body[0]));
            }
            symbolBuilder.append(", ");
            symbolBuilder.append("$L");
            symbolBuilder.append(")");
        }
        return symbolBuilder.toString();
    }

    @Override
    public String generatePoetStringTypes() {
        StringBuilder symbolBuilder = new StringBuilder();
        if (this.getMethodReturnType().equals(this.theContract)) {
            symbolBuilder.append("$L = $T.");
        } else {
            symbolBuilder.append("$T $L = $L.");
        }
        symbolBuilder.append(this.method.getName()).append("(").append(this.getPoetFormatSpecifier()).append(").send()");
        return symbolBuilder.toString();
    }

    @Override
    protected Object getDefaultValueForType(Class<?> type) {
        if (this.mappingHelper.getDefaultValueMap().containsKey(type)) {
            return this.mappingHelper.getDefaultValueMap().get(type);
        }
        return NameUtils.toCamelCase(type);
    }

    @Override
    protected String getPoetFormatSpecifier() {
        ArrayList generated = new ArrayList();
        Arrays.asList(this.method.getParameterTypes()).forEach(type -> generated.add(this.mappingHelper.getPoetFormat().getOrDefault(type, "$L")));
        return String.join((CharSequence)", ", generated);
    }
}

