/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.com.google.common.collect;

import java.util.Comparator;
import javax.annotation.Nullable;
import org.weakref.jmx.com.google.common.annotations.GwtCompatible;
import org.weakref.jmx.com.google.common.base.Preconditions;
import org.weakref.jmx.com.google.common.collect.BstBalancePolicy;
import org.weakref.jmx.com.google.common.collect.BstInOrderPath;
import org.weakref.jmx.com.google.common.collect.BstModificationResult;
import org.weakref.jmx.com.google.common.collect.BstModifier;
import org.weakref.jmx.com.google.common.collect.BstMutationResult;
import org.weakref.jmx.com.google.common.collect.BstMutationRule;
import org.weakref.jmx.com.google.common.collect.BstNode;
import org.weakref.jmx.com.google.common.collect.BstNodeFactory;
import org.weakref.jmx.com.google.common.collect.BstSide;

@GwtCompatible
final class BstOperations {
    private BstOperations() {
    }

    @Nullable
    public static <K, N extends BstNode<K, N>> N seek(Comparator<? super K> comparator, @Nullable N tree, @Nullable K key) {
        Preconditions.checkNotNull(comparator);
        if (tree == null) {
            return null;
        }
        int cmp = comparator.compare(key, tree.getKey());
        if (cmp == 0) {
            return tree;
        }
        BstSide side = cmp < 0 ? BstSide.LEFT : BstSide.RIGHT;
        return BstOperations.seek(comparator, tree.childOrNull(side), key);
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> mutate(Comparator<? super K> comparator, BstMutationRule<K, N> mutationRule, @Nullable N tree, @Nullable K key) {
        int cmp;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(mutationRule);
        if (tree != null && (cmp = comparator.compare(key, tree.getKey())) != 0) {
            BstSide side = cmp < 0 ? BstSide.LEFT : BstSide.RIGHT;
            BstMutationResult<K, N> mutation = BstOperations.mutate(comparator, mutationRule, tree.childOrNull(side), key);
            return mutation.lift(tree, side, mutationRule.getNodeFactory(), mutationRule.getBalancePolicy());
        }
        return BstOperations.modify(tree, key, mutationRule);
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> mutate(BstInOrderPath<N> path, BstMutationRule<K, N> mutationRule) {
        Preconditions.checkNotNull(path);
        Preconditions.checkNotNull(mutationRule);
        BstBalancePolicy<N> balancePolicy = mutationRule.getBalancePolicy();
        BstNodeFactory<N> nodeFactory = mutationRule.getNodeFactory();
        Object target = path.getTip();
        K key = ((BstNode)target).getKey();
        BstMutationResult result = BstOperations.modify(target, key, mutationRule);
        while (path.hasPrefix()) {
            BstInOrderPath prefix = (BstInOrderPath)path.getPrefix();
            result = result.lift(prefix.getTip(), path.getSideOfExtension(), nodeFactory, balancePolicy);
            path = prefix;
        }
        return result;
    }

    private static <K, N extends BstNode<K, N>> BstMutationResult<K, N> modify(@Nullable N tree, K key, BstMutationRule<K, N> mutationRule) {
        N changedRoot;
        BstBalancePolicy<Object> rebalancePolicy = mutationRule.getBalancePolicy();
        BstNodeFactory<Object> nodeFactory = mutationRule.getNodeFactory();
        BstModifier<K, Object> modifier = mutationRule.getModifier();
        N originalRoot = tree;
        Object originalTarget = tree == null ? null : (Object)nodeFactory.createLeaf(tree);
        BstModificationResult<Object> modResult = modifier.modify(key, originalTarget);
        Object originalLeft = null;
        Object originalRight = null;
        if (tree != null) {
            originalLeft = tree.childOrNull(BstSide.LEFT);
            originalRight = tree.childOrNull(BstSide.RIGHT);
        }
        switch (modResult.getType()) {
            case IDENTITY: {
                changedRoot = tree;
                break;
            }
            case REBUILDING_CHANGE: {
                if (modResult.getChangedTarget() != null) {
                    changedRoot = nodeFactory.createNode(modResult.getChangedTarget(), originalLeft, originalRight);
                    break;
                }
                if (tree == null) {
                    changedRoot = null;
                    break;
                }
                throw new AssertionError((Object)"Modification result is a REBUILDING_CHANGE, but rebalancing required");
            }
            case REBALANCING_CHANGE: {
                if (modResult.getChangedTarget() != null) {
                    changedRoot = rebalancePolicy.balance(nodeFactory, modResult.getChangedTarget(), originalLeft, originalRight);
                    break;
                }
                if (tree != null) {
                    changedRoot = rebalancePolicy.combine(nodeFactory, originalLeft, originalRight);
                    break;
                }
                changedRoot = null;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return BstMutationResult.mutationResult(key, originalRoot, changedRoot, modResult);
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> extractMin(N root, BstNodeFactory<N> nodeFactory, BstBalancePolicy<N> balancePolicy) {
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(nodeFactory);
        Preconditions.checkNotNull(balancePolicy);
        if (root.hasChild(BstSide.LEFT)) {
            BstMutationResult<K, N> subResult = BstOperations.extractMin(root.getChild(BstSide.LEFT), nodeFactory, balancePolicy);
            return subResult.lift(root, BstSide.LEFT, nodeFactory, balancePolicy);
        }
        return BstMutationResult.mutationResult(root.getKey(), root, root.childOrNull(BstSide.RIGHT), BstModificationResult.rebalancingChange(root, null));
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> extractMax(N root, BstNodeFactory<N> nodeFactory, BstBalancePolicy<N> balancePolicy) {
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(nodeFactory);
        Preconditions.checkNotNull(balancePolicy);
        if (root.hasChild(BstSide.RIGHT)) {
            BstMutationResult<K, N> subResult = BstOperations.extractMax(root.getChild(BstSide.RIGHT), nodeFactory, balancePolicy);
            return subResult.lift(root, BstSide.RIGHT, nodeFactory, balancePolicy);
        }
        return BstMutationResult.mutationResult(root.getKey(), root, root.childOrNull(BstSide.LEFT), BstModificationResult.rebalancingChange(root, null));
    }

    public static <N extends BstNode<?, N>> N insertMin(@Nullable N root, N entry, BstNodeFactory<N> nodeFactory, BstBalancePolicy<N> balancePolicy) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkNotNull(nodeFactory);
        Preconditions.checkNotNull(balancePolicy);
        if (root == null) {
            return nodeFactory.createLeaf(entry);
        }
        return balancePolicy.balance(nodeFactory, root, BstOperations.insertMin(root.childOrNull(BstSide.LEFT), entry, nodeFactory, balancePolicy), root.childOrNull(BstSide.RIGHT));
    }

    public static <N extends BstNode<?, N>> N insertMax(@Nullable N root, N entry, BstNodeFactory<N> nodeFactory, BstBalancePolicy<N> balancePolicy) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkNotNull(nodeFactory);
        Preconditions.checkNotNull(balancePolicy);
        if (root == null) {
            return nodeFactory.createLeaf(entry);
        }
        return balancePolicy.balance(nodeFactory, root, root.childOrNull(BstSide.LEFT), BstOperations.insertMax(root.childOrNull(BstSide.RIGHT), entry, nodeFactory, balancePolicy));
    }
}

