/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.HashMap;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueFloat;

public class CssAngle
extends CssValue
implements CssValueFloat {
    public static final int type = 7;
    Float value;
    String unit;
    static final String deg = "deg";
    static final String rad = "rad";
    static final String grad = "grad";
    private static final HashMap<String, String> allowed_values;
    static Float defaultValue;

    public final int getType() {
        return 7;
    }

    public CssAngle() {
        this(defaultValue);
    }

    public CssAngle(float v) {
        this(new Float(v));
    }

    public CssAngle(Float angle) {
        this.value = angle;
    }

    public void set(String s, ApplContext ac) throws InvalidParamException {
        String unit;
        s = s.toLowerCase();
        int length = s.length();
        if (s.indexOf(grad) == -1) {
            unit = s.substring(length - 3, length);
            if ((unit = allowed_values.get(unit)) == null) {
                throw new InvalidParamException("unit", unit, ac);
            }
            this.value = new Float(s.substring(0, length - 3));
        } else {
            unit = grad;
            this.value = new Float(s.substring(0, length - 4));
        }
        this.unit = unit;
    }

    public Object get() {
        return this.value;
    }

    public float getValue() {
        return this.value.floatValue();
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        if (this.value.floatValue() != 0.0f) {
            return Util.displayFloat(this.value) + this.getUnit();
        }
        return Util.displayFloat(this.value);
    }

    public boolean equals(Object value) {
        return value instanceof CssAngle && this.value.equals(((CssAngle)value).value) && this.unit == ((CssAngle)value).unit;
    }

    private float normalize(float degree) {
        while (degree < 0.0f) {
            degree += 360.0f;
        }
        while (degree > 360.0f) {
            degree -= 360.0f;
        }
        return degree;
    }

    public float getDegree() {
        float angle = this.value.floatValue();
        if (this.unit == deg) {
            return this.normalize(angle);
        }
        if (this.unit == rad) {
            return this.normalize(angle * 57.295776f);
        }
        if (this.unit == grad) {
            return this.normalize(angle * 0.9f);
        }
        System.err.println("[ERROR] in org.w3c.css.values.CssAngle");
        System.err.println("[ERROR] Please report (" + this.unit + ")");
        return 0.0f;
    }

    public boolean isDegree() {
        return this.unit == deg;
    }

    public boolean isGradian() {
        return this.unit == grad;
    }

    public boolean isRadian() {
        return this.unit == rad;
    }

    static {
        defaultValue = new Float(0.0f);
        allowed_values = new HashMap();
        allowed_values.put(deg, deg);
        allowed_values.put(rad, rad);
        allowed_values.put(grad, grad);
    }
}

