/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css2.user;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css2.user.Css2Style;
import org.w3c.css.properties.css2.user.Outline;
import org.w3c.css.properties.css2.user.UserProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class OutlineColor
extends UserProperty {
    CssValue color;
    private static final CssIdent invert = new CssIdent("invert");

    public OutlineColor() {
        this.color = invert;
    }

    public OutlineColor(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        if (val.equals(inherit)) {
            this.color = inherit;
            expression.next();
        } else if (val.equals(invert)) {
            this.color = invert;
            expression.next();
        } else if (val instanceof CssColor) {
            this.color = val;
            expression.next();
        } else if (val instanceof CssIdent) {
            this.color = new CssColor(ac, (String)val.get());
            expression.next();
        } else {
            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
        }
    }

    public OutlineColor(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.color;
    }

    public boolean isSoftlyInherited() {
        return this.color.equals(inherit);
    }

    public String toString() {
        return this.color.toString();
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        Outline outline = ((Css2Style)style).outline;
        if (outline.color != null) {
            style.addRedefinitionWarning(ac, this);
        }
        outline.color = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css2Style)style).getOutlineColor();
        }
        return ((Css2Style)style).outline.color;
    }

    public boolean equals(CssProperty property) {
        return property instanceof OutlineColor && this.color.equals(((OutlineColor)property).color);
    }

    public String getPropertyName() {
        return "outline-color";
    }
}

