/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css1.CssFontConstant;
import org.w3c.css.properties.css1.CssFontFamily;
import org.w3c.css.properties.css1.CssFontSize;
import org.w3c.css.properties.css1.CssFontStyle;
import org.w3c.css.properties.css1.CssFontVariant;
import org.w3c.css.properties.css1.CssFontWeight;
import org.w3c.css.properties.css1.CssLineHeight;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssValue;

public class CssFont
extends CssProperty
implements CssOperator,
CssFontConstant {
    CssValue value;
    CssFontStyle fontStyle;
    CssFontVariant fontVariant;
    CssFontWeight fontWeight;
    CssFontSize fontSize;
    CssLineHeight lineHeight;
    CssFontFamily fontFamily;
    private static int[] hash_values;
    static CssIdent normal;

    public CssFont() {
    }

    public CssFont(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        CssIdent ident;
        CssValue val = expression.getValue();
        char op = ' ';
        boolean find = true;
        int max_values = 3;
        int normalNb = 0;
        if (val instanceof CssIdent && (ident = this.checkIdent((CssIdent)val)) != null) {
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.value = ident;
            expression.next();
            return;
        }
        while (find && max_values-- > 0) {
            find = false;
            val = expression.getValue();
            op = expression.getOperator();
            if (val == null) {
                throw new InvalidParamException("few-value", this.getPropertyName(), ac);
            }
            if (val.equals(inherit)) {
                throw new InvalidParamException("unrecognize", ac);
            }
            if (val.equals(normal)) {
                ++normalNb;
                expression.next();
                find = true;
            }
            if (!find && this.fontStyle == null) {
                try {
                    this.fontStyle = new CssFontStyle(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.fontVariant == null) {
                try {
                    this.fontVariant = new CssFontVariant(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.fontWeight == null) {
                try {
                    this.fontWeight = new CssFontWeight(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find || op == 32) continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        CssExpression normalExpr = new CssExpression();
        normalExpr.addValue(normal);
        for (int i = 0; i < normalNb; ++i) {
            if (this.fontStyle == null) {
                this.fontStyle = new CssFontStyle(ac, normalExpr);
                normalExpr.starts();
                continue;
            }
            if (this.fontVariant == null) {
                this.fontVariant = new CssFontVariant(ac, normalExpr);
                normalExpr.starts();
                continue;
            }
            if (this.fontWeight != null) continue;
            this.fontWeight = new CssFontWeight(ac, normalExpr);
            normalExpr.starts();
        }
        val = expression.getValue();
        op = expression.getOperator();
        if (val == null) {
            throw new InvalidParamException("few-value", this.getPropertyName(), ac);
        }
        if (val.equals(inherit)) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.fontSize = new CssFontSize(ac, expression);
        if (op == '/') {
            op = expression.getOperator();
            if (expression.getValue().equals(inherit)) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.lineHeight = new CssLineHeight(ac, expression);
        }
        if (expression.getValue().equals(inherit)) {
            throw new InvalidParamException("unrecognize", ac);
        }
        if (op != ' ' || expression.getValue() == null) {
            expression.starts();
            throw new InvalidParamException("few-value", expression.toString(), ac);
        }
        this.fontFamily = new CssFontFamily(ac, expression, true);
        this.setByUser();
    }

    public CssFont(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return null;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        String ret = "";
        if (this.fontStyle != null) {
            ret = ret + " " + this.fontStyle;
        }
        if (this.fontVariant != null) {
            ret = ret + " " + this.fontVariant;
        }
        if (this.fontWeight != null) {
            ret = ret + " " + this.fontWeight;
        }
        if (this.fontSize != null) {
            ret = ret + " " + this.fontSize;
        }
        if (this.lineHeight != null) {
            ret = ret + "/" + this.lineHeight;
        }
        if (this.fontFamily.size() != 0) {
            ret = ret + " " + this.fontFamily;
        }
        return ret.substring(1);
    }

    public void setImportant() {
        super.setImportant();
        if (this.value == null) {
            if (this.fontStyle != null) {
                this.fontStyle.important = true;
            }
            if (this.fontVariant != null) {
                this.fontVariant.important = true;
            }
            if (this.fontWeight != null) {
                this.fontWeight.important = true;
            }
            if (this.fontSize != null) {
                this.fontSize.important = true;
            }
            if (this.lineHeight != null) {
                this.lineHeight.important = true;
            }
            if (this.fontFamily != null) {
                this.fontFamily.important = true;
            }
        }
    }

    public boolean getImportant() {
        if (this.value != null) {
            return super.getImportant();
        }
        return !(this.fontStyle != null && !this.fontStyle.important || this.fontVariant != null && !this.fontVariant.important || this.fontWeight != null && !this.fontWeight.important || this.fontSize != null && !this.fontSize.important || this.lineHeight != null && !this.lineHeight.important || this.fontFamily != null && !this.fontFamily.important);
    }

    public void print(CssPrinterStyle printer) {
        if (this.value != null) {
            printer.print(this);
        } else if (!(this.fontStyle == null || this.fontVariant == null || this.fontWeight == null || this.fontSize == null || this.lineHeight == null || this.fontFamily == null || !this.getImportant() && (this.fontStyle.important || this.fontVariant.important || this.fontWeight.important || this.fontSize.important || this.lineHeight.important || this.fontFamily.important))) {
            printer.print(this);
        } else {
            if (this.fontStyle != null) {
                this.fontStyle.print(printer);
            }
            if (this.fontVariant != null) {
                this.fontVariant.print(printer);
            }
            if (this.fontWeight != null) {
                this.fontWeight.print(printer);
            }
            if (this.fontSize != null) {
                this.fontSize.print(printer);
            }
            if (this.lineHeight != null) {
                this.lineHeight.print(printer);
            }
            if (this.fontFamily != null && (this.fontFamily.isSoftlyInherited() || this.fontFamily.size() != 0)) {
                this.fontFamily.print(printer);
            }
        }
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (this.value != null) {
            ((Css1Style)style).cssFont.value = this.value;
        } else {
            if (this.fontStyle != null) {
                this.fontStyle.addToStyle(ac, style);
            }
            if (this.fontVariant != null) {
                this.fontVariant.addToStyle(ac, style);
            }
            if (this.fontSize != null) {
                this.fontSize.addToStyle(ac, style);
            }
            if (this.fontWeight != null) {
                this.fontWeight.addToStyle(ac, style);
            }
            if (this.lineHeight != null) {
                this.lineHeight.addToStyle(ac, style);
            }
            if (this.fontFamily != null) {
                this.fontFamily.addToStyle(ac, style);
            }
        }
    }

    public void setInfo(int line, String source) {
        super.setInfo(line, source);
        if (this.value == null) {
            if (this.fontStyle != null) {
                this.fontStyle.setInfo(line, source);
            }
            if (this.fontVariant != null) {
                this.fontVariant.setInfo(line, source);
            }
            if (this.fontWeight != null) {
                this.fontWeight.setInfo(line, source);
            }
            if (this.fontSize != null) {
                this.fontSize.setInfo(line, source);
            }
            if (this.lineHeight != null) {
                this.lineHeight.setInfo(line, source);
            }
            if (this.fontFamily != null) {
                this.fontFamily.setInfo(line, source);
            }
        }
    }

    public boolean equals(CssProperty property) {
        return false;
    }

    public void setSelectors(CssSelectors selector) {
        super.setSelectors(selector);
        if (this.fontStyle != null) {
            this.fontStyle.setSelectors(selector);
        }
        if (this.fontVariant != null) {
            this.fontVariant.setSelectors(selector);
        }
        if (this.fontWeight != null) {
            this.fontWeight.setSelectors(selector);
        }
        if (this.fontSize != null) {
            this.fontSize.setSelectors(selector);
        }
        if (this.lineHeight != null) {
            this.lineHeight.setSelectors(selector);
        }
        if (this.fontFamily != null) {
            this.fontFamily.setSelectors(selector);
        }
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getFont();
        }
        return ((Css1Style)style).cssFont;
    }

    public String getPropertyName() {
        return "font";
    }

    private CssIdent checkIdent(CssIdent ident) {
        int hash = ident.hashCode();
        for (int i = 0; i < CssFontConstant.FONT.length; ++i) {
            if (hash_values[i] != hash) continue;
            return ident;
        }
        return null;
    }

    static {
        normal = new CssIdent("normal");
        hash_values = new int[CssFontConstant.FONT.length];
        for (int i = 0; i < CssFontConstant.FONT.length; ++i) {
            CssFont.hash_values[i] = CssFontConstant.FONT[i].hashCode();
        }
    }
}

