/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class CssBorderFaceWidth {
    CssValue value;
    private static CssIdent thin = new CssIdent("thin");
    private static CssIdent medium = new CssIdent("medium");
    private static CssIdent thick = new CssIdent("thick");

    public CssBorderFaceWidth() {
    }

    public CssBorderFaceWidth(CssBorderFaceWidth another) {
        this.value = another.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CssBorderFaceWidth(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        CssIdent initial = new CssIdent("initial");
        if (val instanceof CssLength) {
            float f = ((Float)val.get()).floatValue();
            if (!(f >= 0.0f)) throw new InvalidParamException("negative-value", val.toString(), ac);
            this.value = val;
        } else if (val instanceof CssNumber) {
            this.value = ((CssNumber)val).getLength();
        } else if (val instanceof CssPercentage) {
            this.value = val;
        } else if (val.equals(thin)) {
            this.value = thin;
        } else if (val.equals(medium)) {
            this.value = medium;
        } else if (val.equals(thick)) {
            this.value = thick;
        } else if (val.equals(initial)) {
            this.value = initial;
        } else {
            if (!val.equals(CssProperty.inherit)) throw new InvalidParamException("value", val.toString(), "width", ac);
            this.value = CssProperty.inherit;
        }
        expression.next();
    }

    public CssBorderFaceWidth(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssValue getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "";
    }

    public boolean equals(CssBorderFaceWidth another) {
        return this.value.equals(another.value);
    }
}

