/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css;

import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.Css3Style;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBackgroundSize
extends CssProperty {
    private static final String propertyName = "background-size";
    private static CssIdent auto = CssIdent.getIdent("auto");
    private static HashMap<String, CssIdent> allowed_values = new HashMap();
    Object value;

    public static boolean isMatchingIdent(CssIdent ident) {
        return allowed_values.containsKey(ident.toString());
    }

    public CssBackgroundSize() {
        this.value = auto;
    }

    public CssBackgroundSize(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        CssValueList vl = null;
        boolean is_complete = true;
        this.setByUser();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val = ((CssNumber)val).getLength();
                }
                case 4: 
                case 6: {
                    float f = ((Float)val.get()).floatValue();
                    if (f < 0.0f) {
                        throw new InvalidParamException("negative-value", val.toString(), ac);
                    }
                    if (is_complete) {
                        vl = new CssValueList();
                        vl.add(val);
                    } else {
                        vl.add(val);
                        values.add(vl);
                    }
                    is_complete = !is_complete;
                    break;
                }
                case 0: {
                    if (inherit.equals(val)) {
                        if (values.size() > 0 || expression.getCount() > 1) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        values.add(inherit);
                        break;
                    }
                    if (auto.equals(val)) {
                        if (is_complete) {
                            vl = new CssValueList();
                            vl.add(auto);
                        } else {
                            vl.add(auto);
                            values.add(vl);
                        }
                        is_complete = !is_complete;
                        break;
                    }
                    CssValue v = allowed_values.get(val.toString());
                    if (v != null && is_complete) {
                        values.add(v);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (expression.end()) continue;
            if (!is_complete && op == ',') {
                values.add(vl);
                is_complete = true;
            }
            if ((!is_complete || op == ',') && (is_complete || op == ' ')) continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (!is_complete) {
            values.add(vl);
        }
        this.value = values.size() == 1 ? values.get(0) : values;
    }

    public CssBackgroundSize(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((Css3Style)style).cssBackgroundSize != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((Css3Style)style).cssBackgroundSize = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css3Style)style).getCssBackgroundSize();
        }
        return ((Css3Style)style).cssBackgroundSize;
    }

    public boolean equals(CssProperty property) {
        return property instanceof CssBackgroundSize && this.value.equals(((CssBackgroundSize)property).value);
    }

    public final String getPropertyName() {
        return propertyName;
    }

    public Object get() {
        return this.value;
    }

    public void set(Object val) {
        this.value = val;
    }

    public boolean isSoftlyInherited() {
        return inherit == this.value;
    }

    public String toString() {
        if (this.value instanceof ArrayList) {
            ArrayList values = (ArrayList)this.value;
            StringBuilder sb = new StringBuilder();
            for (Object aValue : values) {
                sb.append(aValue.toString()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            return sb.toString();
        }
        return this.value.toString();
    }

    public boolean isDefault() {
        return auto == this.value;
    }

    static {
        allowed_values.put("auto", auto);
        allowed_values.put("cover", CssIdent.getIdent("cover"));
        allowed_values.put("contain", CssIdent.getIdent("contain"));
    }
}

